<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceResponse StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SendInvoiceResponse
 * @subpackage Structs
 */
class SendInvoiceResponse extends AbstractStructBase
{
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * Constructor method for SendInvoiceResponse
     * @uses SendInvoiceResponse::setREQUEST_RETURN()
     * @uses SendInvoiceResponse::setINVOICE()
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\INVOICE[] $iNVOICE
     */
    public function __construct(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, array $iNVOICE = array())
    {
        $this
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setINVOICE($iNVOICE);
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\SendInvoiceResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\SendInvoiceResponse
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $sendInvoiceResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$sendInvoiceResponseINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($sendInvoiceResponseINVOICEItem) ? get_class($sendInvoiceResponseINVOICEItem) : gettype($sendInvoiceResponseINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\SendInvoiceResponse
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendInvoiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
