<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MARK StructType
 * @subpackage Structs
 */
class MARK extends AbstractStructBase
{
    /**
     * The ENVELOPE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ENVELOPE[]
     */
    public $ENVELOPE;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * Constructor method for MARK
     * @uses MARK::setENVELOPE()
     * @uses MARK::setValue()
     * @uses MARK::setINVOICE()
     * @param \StructType\ENVELOPE[] $eNVELOPE
     * @param string $value
     * @param \StructType\INVOICE[] $iNVOICE
     */
    public function __construct(array $eNVELOPE = array(), $value = null, array $iNVOICE = array())
    {
        $this
            ->setENVELOPE($eNVELOPE)
            ->setValue($value)
            ->setINVOICE($iNVOICE);
    }
    /**
     * Get ENVELOPE value
     * @return \StructType\ENVELOPE[]|null
     */
    public function getENVELOPE()
    {
        return $this->ENVELOPE;
    }
    /**
     * Set ENVELOPE value
     * @throws \InvalidArgumentException
     * @param \StructType\ENVELOPE[] $eNVELOPE
     * @return \StructType\MARK
     */
    public function setENVELOPE(array $eNVELOPE = array())
    {
        foreach ($eNVELOPE as $mARKENVELOPEItem) {
            // validation for constraint: itemType
            if (!$mARKENVELOPEItem instanceof \StructType\ENVELOPE) {
                throw new \InvalidArgumentException(sprintf('The ENVELOPE property can only contain items of \StructType\ENVELOPE, "%s" given', is_object($mARKENVELOPEItem) ? get_class($mARKENVELOPEItem) : gettype($mARKENVELOPEItem)), __LINE__);
            }
        }
        $this->ENVELOPE = $eNVELOPE;
        return $this;
    }
    /**
     * Add item to ENVELOPE value
     * @throws \InvalidArgumentException
     * @param \StructType\ENVELOPE $item
     * @return \StructType\MARK
     */
    public function addToENVELOPE(\StructType\ENVELOPE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ENVELOPE) {
            throw new \InvalidArgumentException(sprintf('The ENVELOPE property can only contain items of \StructType\ENVELOPE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ENVELOPE[] = $item;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\MARK
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\MARK
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $mARKINVOICEItem) {
            // validation for constraint: itemType
            if (!$mARKINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($mARKINVOICEItem) ? get_class($mARKINVOICEItem) : gettype($mARKINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\MARK
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MARK
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
