<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:LoadInvoiceRequest
 * @subpackage Structs
 */
class LoadInvoiceRequest extends REQUEST
{
    /**
     * The GENERATEINVOICEIDONLOAD
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GENERATEINVOICEIDONLOAD;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The SENDER
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SENDER
     */
    public $SENDER;
    /**
     * The RECEIVER
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RECEIVER
     */
    public $RECEIVER;
    /**
     * Constructor method for LoadInvoiceRequest
     * @uses LoadInvoiceRequest::setGENERATEINVOICEIDONLOAD()
     * @uses LoadInvoiceRequest::setINVOICE()
     * @uses LoadInvoiceRequest::setSENDER()
     * @uses LoadInvoiceRequest::setRECEIVER()
     * @param bool $gENERATEINVOICEIDONLOAD
     * @param \StructType\INVOICE[] $iNVOICE
     * @param \StructType\SENDER $sENDER
     * @param \StructType\RECEIVER $rECEIVER
     */
    public function __construct($gENERATEINVOICEIDONLOAD = null, array $iNVOICE = array(), \StructType\SENDER $sENDER = null, \StructType\RECEIVER $rECEIVER = null)
    {
        $this
            ->setGENERATEINVOICEIDONLOAD($gENERATEINVOICEIDONLOAD)
            ->setINVOICE($iNVOICE)
            ->setSENDER($sENDER)
            ->setRECEIVER($rECEIVER);
    }
    /**
     * Get GENERATEINVOICEIDONLOAD value
     * @return bool
     */
    public function getGENERATEINVOICEIDONLOAD()
    {
        return $this->GENERATEINVOICEIDONLOAD;
    }
    /**
     * Set GENERATEINVOICEIDONLOAD value
     * @param bool $gENERATEINVOICEIDONLOAD
     * @return \StructType\LoadInvoiceRequest
     */
    public function setGENERATEINVOICEIDONLOAD($gENERATEINVOICEIDONLOAD = null)
    {
        $this->GENERATEINVOICEIDONLOAD = $gENERATEINVOICEIDONLOAD;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\LoadInvoiceRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $loadInvoiceRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$loadInvoiceRequestINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($loadInvoiceRequestINVOICEItem) ? get_class($loadInvoiceRequestINVOICEItem) : gettype($loadInvoiceRequestINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\LoadInvoiceRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get SENDER value
     * @return \StructType\SENDER|null
     */
    public function getSENDER()
    {
        return $this->SENDER;
    }
    /**
     * Set SENDER value
     * @param \StructType\SENDER $sENDER
     * @return \StructType\LoadInvoiceRequest
     */
    public function setSENDER(\StructType\SENDER $sENDER = null)
    {
        $this->SENDER = $sENDER;
        return $this;
    }
    /**
     * Get RECEIVER value
     * @return \StructType\RECEIVER|null
     */
    public function getRECEIVER()
    {
        return $this->RECEIVER;
    }
    /**
     * Set RECEIVER value
     * @param \StructType\RECEIVER $rECEIVER
     * @return \StructType\LoadInvoiceRequest
     */
    public function setRECEIVER(\StructType\RECEIVER $rECEIVER = null)
    {
        $this->RECEIVER = $rECEIVER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoadInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
