<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceRequest $sendInvoiceRequest
     * @return \StructType\SendInvoiceResponse|bool
     */
    public function SendInvoice(\StructType\SendInvoiceRequest $sendInvoiceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SendInvoice($sendInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceResponseRequest $sendInvoiceResponseRequest
     * @return \StructType\SendInvoiceResponseResponse|bool
     */
    public function SendInvoiceResponse(\StructType\SendInvoiceResponseRequest $sendInvoiceResponseRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SendInvoiceResponse($sendInvoiceResponseRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceResponseWithServerSign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceResponseWithServerSignRequest $sendInvoiceResponseWithServerSignRequest
     * @return \StructType\SendInvoiceResponseWithServerSignResponse|bool
     */
    public function SendInvoiceResponseWithServerSign(\StructType\SendInvoiceResponseWithServerSignRequest $sendInvoiceResponseWithServerSignRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SendInvoiceResponseWithServerSign($sendInvoiceResponseWithServerSignRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendInvoiceResponse|\StructType\SendInvoiceResponseResponse|\StructType\SendInvoiceResponseWithServerSignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
