<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @subpackage Services
 */
class Prepare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrepareInvoiceResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareInvoiceResponseRequest $prepareInvoiceResponseRequest
     * @return \ArrayType\ArrayOfBase64Binary|bool
     */
    public function PrepareInvoiceResponse(\StructType\PrepareInvoiceResponseRequest $prepareInvoiceResponseRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->PrepareInvoiceResponse($prepareInvoiceResponseRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ArrayType\ArrayOfBase64Binary
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
