<?php

namespace EnumType;

/**
 * This class stands for USERTYPE EnumType
 * @subpackage Enumerations
 */
class USERTYPE
{
    /**
     * Constant for value 'USER'
     * @return string 'USER'
     */
    const VALUE_USER = 'USER';
    /**
     * Constant for value 'ARCHIVE'
     * @return string 'ARCHIVE'
     */
    const VALUE_ARCHIVE = 'ARCHIVE';
    /**
     * Constant for value 'EARCHIVE'
     * @return string 'EARCHIVE'
     */
    const VALUE_EARCHIVE = 'EARCHIVE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_ARCHIVE
     * @uses self::VALUE_EARCHIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_ARCHIVE,
            self::VALUE_EARCHIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
