<?php

namespace EnumType;

/**
 * This class stands for TYPE EnumType
 * @subpackage Enumerations
 */
class TYPE
{
    /**
     * Constant for value 'CSV'
     * @return string 'CSV'
     */
    const VALUE_CSV = 'CSV';
    /**
     * Constant for value 'XML'
     * @return string 'XML'
     */
    const VALUE_XML = 'XML';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CSV
     * @uses self::VALUE_XML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CSV,
            self::VALUE_XML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
