<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfINVOICE ArrayType
 * @subpackage Arrays
 */
class ArrayOfINVOICE extends AbstractStructArrayBase
{
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * Constructor method for ArrayOfINVOICE
     * @uses ArrayOfINVOICE::setINVOICE()
     * @param \StructType\INVOICE[] $iNVOICE
     */
    public function __construct(array $iNVOICE = array())
    {
        $this
            ->setINVOICE($iNVOICE);
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \ArrayType\ArrayOfINVOICE
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $arrayOfINVOICEINVOICEItem) {
            // validation for constraint: itemType
            if (!$arrayOfINVOICEINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($arrayOfINVOICEINVOICEItem) ? get_class($arrayOfINVOICEINVOICEItem) : gettype($arrayOfINVOICEINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \ArrayType\ArrayOfINVOICE
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\INVOICE|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\INVOICE|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\INVOICE|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\INVOICE|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\INVOICE|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string INVOICE
     */
    public function getAttributeName()
    {
        return 'INVOICE';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfINVOICE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
