<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VariationProductListingDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type defines the <b>VariationProductListingDetails</b> container that is used to specify an EAN, an ISBN, or a UPC value to identify a specific product variation in a multi-variation listing. For multi-variation listings, the
 * same product identifier type must be used for all product variations within the listing. For instance, if one product variation uses ISBNs, all product variations must use ISBN values. <br> <br> <span class="tablenote"><b>Note:</b> The
 * <b>NameValueList</b> container was added in Version 997, but it is not yet available for use in Sandbox or Production environments. Ultimately, specifying product identifiers for a product variation through the <b>NameValueList</b> container will
 * replace the process of specifying product identifiers through the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields. See the documentation for the <b>NameValueList</b> container for more information on how product identifiers are specified through this
 * container. For more information on effective dates on this feature change and transition, see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product
 * Identifiers Mandate</a>. </span>
 * @subpackage Structs
 */
class VariationProductListingDetailsType extends AbstractStructBase
{
    /**
     * The ISBN
     * Meta informations extracted from the WSDL
     * - documentation: This field is used if the seller wishes to identify each product variation within a multi-variation listing by an ISBN (International Standard Book Number) value. An ISBN is a unique identifer for books. Both 10 and 13-character
     * ISBNs are supported. When specifying a 13-character ISBN, the value must begin with either '978' or '979'. Unlike single-variation listings where the ISBN is specified in the <b>ProductListingDetails</b> container, eBay will attempt to match this
     * ISBN value to a product in the eBay catalog, but the product's item title, item description, item specifics, and stock photos are not automatically picked up for multiple-variation listings. If a secondary category is used, and the primary and
     * secondary categories are both catalog-enabled, this ISBN value should correspond to the primary category (not the secondary category). <br/><br/> <span class="tablenote"><b>Note: </b> If the listing is being posted to a category that expects an ISBN
     * value, but one doesn't exist for the product, the seller must pass in the text that can be found in the <b>ProductDetails.ProductIdentifierUnavailableText</b> field of the <b>GeteBayDetails</b> response. To get the <b>ProductDetails</b> container to
     * return in the <b>GeteBayDetails</b> response, 'ProductDetails' should be included as a <b>DetailName</b> value in the call request. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are
     * used to specify a Global Trade Item Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 (dates will be announced as we approach second half of
     * year), the <b>NameValueList</b> container can start being used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span>
     * - minOccurs: 0
     * @var string
     */
    public $ISBN;
    /**
     * The UPC
     * Meta informations extracted from the WSDL
     * - documentation: This field is used if the seller wishes to identify each product variation within a multi-variation listing by a UPC (Universal Product Code) value. A UPC is a commonly used identifer for many different products. Unlike
     * single-variation listings where the UPC is specified in the <b>ProductListingDetails</b> container, eBay will attempt to match this UPC value to a product in the eBay catalog, but the product's item title, item description, item specifics, and stock
     * photos are not automatically picked up for multiple-variation listings. If a secondary category is used, and the primary and secondary categories are both catalog-enabled, this UPC value should correspond to the primary category (not the secondary
     * category). <br/><br/> <span class="tablenote"><b>Note: </b> If the listing is being posted to a category that expects a UPC value, but one doesn't exist for the product, the seller must pass in the text that can be found in the
     * <b>ProductDetails.ProductIdentifierUnavailableText</b> field of the <b>GeteBayDetails</b> response. To get the <b>ProductDetails</b> container to return in the <b>GeteBayDetails</b> response, 'ProductDetails' should be included as a <b>DetailName</b>
     * value in the call request. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used to specify a Global Trade Item Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if
     * particular product identifier types are supported/required. Starting later in 2017 (dates will be announced as we approach second half of year), the <b>NameValueList</b> container can start being used to specify any and all GTINs, and the
     * <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span>
     * - minOccurs: 0
     * @var string
     */
    public $UPC;
    /**
     * The EAN
     * Meta informations extracted from the WSDL
     * - documentation: This field is used if the seller wishes to identify each product variation within a multi-variation listing by an EAN (European Article Number) value. An EAN is a unique 8 or 13-digit identifier that many industries (such as book
     * publishers) use to identify products. Unlike single-variation listings where the EAN is specified in the <b>ProductListingDetails</b> container, eBay will attempt to match this EAN value to a product in the eBay catalog, but the product's item title,
     * item description, item specifics, and stock photos are not automatically picked up for multiple-variation listings. If a secondary category is used, and the primary and secondary categories are both catalog-enabled, this EAN value should correspond
     * to the primary category (not the secondary category). <br/><br/> <span class="tablenote"><b>Note: </b> If the listing is being posted to a category that expects an EAN value, but one doesn't exist for the product, the seller must pass in the text
     * that can be found in the <b>ProductDetails.ProductIdentifierUnavailableText</b> field of the <b>GeteBayDetails</b> response. To get the <b>ProductDetails</b> container to return in the <b>GeteBayDetails</b> response, 'ProductDetails' should be
     * included as a <b>DetailName</b> value in the call request. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used to specify a Global Trade Item Number (GTIN), and the
     * <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 (dates will be announced as we approach second half of year), the <b>NameValueList</b> container can start being used
     * to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span>
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The NameValueList
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note:</b> The <b>NameValueList</b> container was added in Version 997, but it is not yet available for use in Sandbox or Production environments. Currently, the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields
     * are used to specify a Global Trade Item Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 ( dates will be announced as we approach second half
     * of year), the <b>NameValueList</b> container can start being used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span> This container is used to pass in a name-value pair that will identify the type of product identifier (and its value) being used for a product variation within a multiple-variation listing. This product identifier, such as EAN, ISBN, or UPC,
     * is then used by eBay to try and match the identifier to a product in the eBay catalog. <br> <br> <span class="tablenote"><b>Note:</b> If a brand/MPN pair is going to be used to identify product variations within a multiple-variation listing, the
     * <b>Brand</b> identifier (and its value) should be specified at the listing level, or through the <b>Item.ProductListingDetails.NameValueList</b> container, and each product variation should be identified by its Manufacturer Part Number through the
     * <b>Variation.VariationProductListingDetails.NameValueList</b> container. Please note that a brand cannot vary within the same listing. Each part must be from the same brand. </span> <br> The <b>GetCategorySpecifics</b> call can be used to see the
     * product identifier type(s) that are required/supported for a particular eBay category. Each required/supported product identifier type will be shown in a separate <b>ProductIdentifiers.NameRecommendation</b> container in the
     * <b>GetCategorySpecifics</b> call response. The product identifier type name will be shown in the <b>NameRecommendation.Name</b> field. By looking at the value in the corresponding <b>ProductIdentifiers.ValidationRules.MinRequired</b> field, the
     * seller will know if one or more product identifiers are required at listing time. If two product identifier types are returned, and the <b>MinRequired</b> value is '2', the seller will be required to use both product identifier types at listing time.
     * If the <b>MinRequired</b> value is '1', only one of the two product identifier types would be required, but the seller could use them both if they wanted. If the <b>MinRequired</b> value is 0, one or both of those product identifier types could be
     * used, but they would not be required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NameValueListType[]
     */
    public $NameValueList;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for VariationProductListingDetailsType
     * @uses VariationProductListingDetailsType::setISBN()
     * @uses VariationProductListingDetailsType::setUPC()
     * @uses VariationProductListingDetailsType::setEAN()
     * @uses VariationProductListingDetailsType::setNameValueList()
     * @uses VariationProductListingDetailsType::setAny()
     * @param string $iSBN
     * @param string $uPC
     * @param string $eAN
     * @param \StructType\NameValueListType[] $nameValueList
     * @param \DOMDocument $any
     */
    public function __construct($iSBN = null, $uPC = null, $eAN = null, array $nameValueList = array(), \DOMDocument $any = null)
    {
        $this
            ->setISBN($iSBN)
            ->setUPC($uPC)
            ->setEAN($eAN)
            ->setNameValueList($nameValueList)
            ->setAny($any);
    }
    /**
     * Get ISBN value
     * @return string|null
     */
    public function getISBN()
    {
        return $this->ISBN;
    }
    /**
     * Set ISBN value
     * @param string $iSBN
     * @return \StructType\VariationProductListingDetailsType
     */
    public function setISBN($iSBN = null)
    {
        // validation for constraint: string
        if (!is_null($iSBN) && !is_string($iSBN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSBN)), __LINE__);
        }
        $this->ISBN = $iSBN;
        return $this;
    }
    /**
     * Get UPC value
     * @return string|null
     */
    public function getUPC()
    {
        return $this->UPC;
    }
    /**
     * Set UPC value
     * @param string $uPC
     * @return \StructType\VariationProductListingDetailsType
     */
    public function setUPC($uPC = null)
    {
        // validation for constraint: string
        if (!is_null($uPC) && !is_string($uPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uPC)), __LINE__);
        }
        $this->UPC = $uPC;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\VariationProductListingDetailsType
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get NameValueList value
     * @return \StructType\NameValueListType[]|null
     */
    public function getNameValueList()
    {
        return $this->NameValueList;
    }
    /**
     * Set NameValueList value
     * @throws \InvalidArgumentException
     * @param \StructType\NameValueListType[] $nameValueList
     * @return \StructType\VariationProductListingDetailsType
     */
    public function setNameValueList(array $nameValueList = array())
    {
        foreach ($nameValueList as $variationProductListingDetailsTypeNameValueListItem) {
            // validation for constraint: itemType
            if (!$variationProductListingDetailsTypeNameValueListItem instanceof \StructType\NameValueListType) {
                throw new \InvalidArgumentException(sprintf('The NameValueList property can only contain items of \StructType\NameValueListType, "%s" given', is_object($variationProductListingDetailsTypeNameValueListItem) ? get_class($variationProductListingDetailsTypeNameValueListItem) : gettype($variationProductListingDetailsTypeNameValueListItem)), __LINE__);
            }
        }
        $this->NameValueList = $nameValueList;
        return $this;
    }
    /**
     * Add item to NameValueList value
     * @throws \InvalidArgumentException
     * @param \StructType\NameValueListType $item
     * @return \StructType\VariationProductListingDetailsType
     */
    public function addToNameValueList(\StructType\NameValueListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NameValueListType) {
            throw new \InvalidArgumentException(sprintf('The NameValueList property can only contain items of \StructType\NameValueListType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameValueList[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\VariationProductListingDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\VariationProductListingDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariationProductListingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
