<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingConfirmation StructType
 * @subpackage Structs
 */
class BookingConfirmation extends AbstractStructBase
{
    /**
     * The ProviderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProviderId;
    /**
     * The TrackId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackId;
    /**
     * The SearchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchId;
    /**
     * The HotelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelId;
    /**
     * The RateplanId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateplanId;
    /**
     * The ClientTrackId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientTrackId;
    /**
     * Constructor method for BookingConfirmation
     * @uses BookingConfirmation::setProviderId()
     * @uses BookingConfirmation::setTrackId()
     * @uses BookingConfirmation::setSearchId()
     * @uses BookingConfirmation::setHotelId()
     * @uses BookingConfirmation::setRateplanId()
     * @uses BookingConfirmation::setClientTrackId()
     * @param int $providerId
     * @param string $trackId
     * @param string $searchId
     * @param string $hotelId
     * @param string $rateplanId
     * @param string $clientTrackId
     */
    public function __construct($providerId = null, $trackId = null, $searchId = null, $hotelId = null, $rateplanId = null, $clientTrackId = null)
    {
        $this
            ->setProviderId($providerId)
            ->setTrackId($trackId)
            ->setSearchId($searchId)
            ->setHotelId($hotelId)
            ->setRateplanId($rateplanId)
            ->setClientTrackId($clientTrackId);
    }
    /**
     * Get ProviderId value
     * @return int
     */
    public function getProviderId()
    {
        return $this->ProviderId;
    }
    /**
     * Set ProviderId value
     * @param int $providerId
     * @return \StructType\BookingConfirmation
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: int
        if (!is_null($providerId) && !is_numeric($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerId)), __LINE__);
        }
        $this->ProviderId = $providerId;
        return $this;
    }
    /**
     * Get TrackId value
     * @return string|null
     */
    public function getTrackId()
    {
        return $this->TrackId;
    }
    /**
     * Set TrackId value
     * @param string $trackId
     * @return \StructType\BookingConfirmation
     */
    public function setTrackId($trackId = null)
    {
        // validation for constraint: string
        if (!is_null($trackId) && !is_string($trackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackId)), __LINE__);
        }
        $this->TrackId = $trackId;
        return $this;
    }
    /**
     * Get SearchId value
     * @return string|null
     */
    public function getSearchId()
    {
        return $this->SearchId;
    }
    /**
     * Set SearchId value
     * @param string $searchId
     * @return \StructType\BookingConfirmation
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: string
        if (!is_null($searchId) && !is_string($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchId)), __LINE__);
        }
        $this->SearchId = $searchId;
        return $this;
    }
    /**
     * Get HotelId value
     * @return string|null
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param string $hotelId
     * @return \StructType\BookingConfirmation
     */
    public function setHotelId($hotelId = null)
    {
        // validation for constraint: string
        if (!is_null($hotelId) && !is_string($hotelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelId)), __LINE__);
        }
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get RateplanId value
     * @return string|null
     */
    public function getRateplanId()
    {
        return $this->RateplanId;
    }
    /**
     * Set RateplanId value
     * @param string $rateplanId
     * @return \StructType\BookingConfirmation
     */
    public function setRateplanId($rateplanId = null)
    {
        // validation for constraint: string
        if (!is_null($rateplanId) && !is_string($rateplanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateplanId)), __LINE__);
        }
        $this->RateplanId = $rateplanId;
        return $this;
    }
    /**
     * Get ClientTrackId value
     * @return string|null
     */
    public function getClientTrackId()
    {
        return $this->ClientTrackId;
    }
    /**
     * Set ClientTrackId value
     * @param string $clientTrackId
     * @return \StructType\BookingConfirmation
     */
    public function setClientTrackId($clientTrackId = null)
    {
        // validation for constraint: string
        if (!is_null($clientTrackId) && !is_string($clientTrackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientTrackId)), __LINE__);
        }
        $this->ClientTrackId = $clientTrackId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingConfirmation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
