<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearch StructType
 * @subpackage Structs
 */
class HotelSearch extends AbstractStructBase
{
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The CheckIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckIn;
    /**
     * The CheckOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckOut;
    /**
     * The RoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomInfo;
    /**
     * Constructor method for HotelSearch
     * @uses HotelSearch::setCityName()
     * @uses HotelSearch::setCheckIn()
     * @uses HotelSearch::setCheckOut()
     * @uses HotelSearch::setRoomInfo()
     * @param string $cityName
     * @param string $checkIn
     * @param string $checkOut
     * @param string $roomInfo
     */
    public function __construct($cityName = null, $checkIn = null, $checkOut = null, $roomInfo = null)
    {
        $this
            ->setCityName($cityName)
            ->setCheckIn($checkIn)
            ->setCheckOut($checkOut)
            ->setRoomInfo($roomInfo);
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\HotelSearch
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get CheckIn value
     * @return string|null
     */
    public function getCheckIn()
    {
        return $this->CheckIn;
    }
    /**
     * Set CheckIn value
     * @param string $checkIn
     * @return \StructType\HotelSearch
     */
    public function setCheckIn($checkIn = null)
    {
        // validation for constraint: string
        if (!is_null($checkIn) && !is_string($checkIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkIn)), __LINE__);
        }
        $this->CheckIn = $checkIn;
        return $this;
    }
    /**
     * Get CheckOut value
     * @return string|null
     */
    public function getCheckOut()
    {
        return $this->CheckOut;
    }
    /**
     * Set CheckOut value
     * @param string $checkOut
     * @return \StructType\HotelSearch
     */
    public function setCheckOut($checkOut = null)
    {
        // validation for constraint: string
        if (!is_null($checkOut) && !is_string($checkOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOut)), __LINE__);
        }
        $this->CheckOut = $checkOut;
        return $this;
    }
    /**
     * Get RoomInfo value
     * @return string|null
     */
    public function getRoomInfo()
    {
        return $this->RoomInfo;
    }
    /**
     * Set RoomInfo value
     * @param string $roomInfo
     * @return \StructType\HotelSearch
     */
    public function setRoomInfo($roomInfo = null)
    {
        // validation for constraint: string
        if (!is_null($roomInfo) && !is_string($roomInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomInfo)), __LINE__);
        }
        $this->RoomInfo = $roomInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
