<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingTrack StructType
 * @subpackage Structs
 */
class BookingTrack extends AbstractStructBase
{
    /**
     * The ProviderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProviderId;
    /**
     * The BookingAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BookingAmount;
    /**
     * The NoofNights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoofNights;
    /**
     * The SearchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchId;
    /**
     * The HotelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelId;
    /**
     * The CheckIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckIn;
    /**
     * The CheckOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckOut;
    /**
     * The RoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomInfo;
    /**
     * The RateplanId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateplanId;
    /**
     * The RoomTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeID;
    /**
     * The Fname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fname;
    /**
     * The Lname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lname;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * Constructor method for BookingTrack
     * @uses BookingTrack::setProviderId()
     * @uses BookingTrack::setBookingAmount()
     * @uses BookingTrack::setNoofNights()
     * @uses BookingTrack::setSearchId()
     * @uses BookingTrack::setHotelId()
     * @uses BookingTrack::setCheckIn()
     * @uses BookingTrack::setCheckOut()
     * @uses BookingTrack::setRoomInfo()
     * @uses BookingTrack::setRateplanId()
     * @uses BookingTrack::setRoomTypeID()
     * @uses BookingTrack::setFname()
     * @uses BookingTrack::setLname()
     * @uses BookingTrack::setAddress()
     * @uses BookingTrack::setCity()
     * @uses BookingTrack::setCountry()
     * @uses BookingTrack::setPostalCode()
     * @uses BookingTrack::setMobile()
     * @uses BookingTrack::setEmail()
     * @uses BookingTrack::setState()
     * @param int $providerId
     * @param float $bookingAmount
     * @param int $noofNights
     * @param string $searchId
     * @param string $hotelId
     * @param string $checkIn
     * @param string $checkOut
     * @param string $roomInfo
     * @param string $rateplanId
     * @param string $roomTypeID
     * @param string $fname
     * @param string $lname
     * @param string $address
     * @param string $city
     * @param string $country
     * @param string $postalCode
     * @param string $mobile
     * @param string $email
     * @param string $state
     */
    public function __construct($providerId = null, $bookingAmount = null, $noofNights = null, $searchId = null, $hotelId = null, $checkIn = null, $checkOut = null, $roomInfo = null, $rateplanId = null, $roomTypeID = null, $fname = null, $lname = null, $address = null, $city = null, $country = null, $postalCode = null, $mobile = null, $email = null, $state = null)
    {
        $this
            ->setProviderId($providerId)
            ->setBookingAmount($bookingAmount)
            ->setNoofNights($noofNights)
            ->setSearchId($searchId)
            ->setHotelId($hotelId)
            ->setCheckIn($checkIn)
            ->setCheckOut($checkOut)
            ->setRoomInfo($roomInfo)
            ->setRateplanId($rateplanId)
            ->setRoomTypeID($roomTypeID)
            ->setFname($fname)
            ->setLname($lname)
            ->setAddress($address)
            ->setCity($city)
            ->setCountry($country)
            ->setPostalCode($postalCode)
            ->setMobile($mobile)
            ->setEmail($email)
            ->setState($state);
    }
    /**
     * Get ProviderId value
     * @return int
     */
    public function getProviderId()
    {
        return $this->ProviderId;
    }
    /**
     * Set ProviderId value
     * @param int $providerId
     * @return \StructType\BookingTrack
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: int
        if (!is_null($providerId) && !is_numeric($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerId)), __LINE__);
        }
        $this->ProviderId = $providerId;
        return $this;
    }
    /**
     * Get BookingAmount value
     * @return float
     */
    public function getBookingAmount()
    {
        return $this->BookingAmount;
    }
    /**
     * Set BookingAmount value
     * @param float $bookingAmount
     * @return \StructType\BookingTrack
     */
    public function setBookingAmount($bookingAmount = null)
    {
        $this->BookingAmount = $bookingAmount;
        return $this;
    }
    /**
     * Get NoofNights value
     * @return int
     */
    public function getNoofNights()
    {
        return $this->NoofNights;
    }
    /**
     * Set NoofNights value
     * @param int $noofNights
     * @return \StructType\BookingTrack
     */
    public function setNoofNights($noofNights = null)
    {
        // validation for constraint: int
        if (!is_null($noofNights) && !is_numeric($noofNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noofNights)), __LINE__);
        }
        $this->NoofNights = $noofNights;
        return $this;
    }
    /**
     * Get SearchId value
     * @return string|null
     */
    public function getSearchId()
    {
        return $this->SearchId;
    }
    /**
     * Set SearchId value
     * @param string $searchId
     * @return \StructType\BookingTrack
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: string
        if (!is_null($searchId) && !is_string($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchId)), __LINE__);
        }
        $this->SearchId = $searchId;
        return $this;
    }
    /**
     * Get HotelId value
     * @return string|null
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param string $hotelId
     * @return \StructType\BookingTrack
     */
    public function setHotelId($hotelId = null)
    {
        // validation for constraint: string
        if (!is_null($hotelId) && !is_string($hotelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelId)), __LINE__);
        }
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get CheckIn value
     * @return string|null
     */
    public function getCheckIn()
    {
        return $this->CheckIn;
    }
    /**
     * Set CheckIn value
     * @param string $checkIn
     * @return \StructType\BookingTrack
     */
    public function setCheckIn($checkIn = null)
    {
        // validation for constraint: string
        if (!is_null($checkIn) && !is_string($checkIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkIn)), __LINE__);
        }
        $this->CheckIn = $checkIn;
        return $this;
    }
    /**
     * Get CheckOut value
     * @return string|null
     */
    public function getCheckOut()
    {
        return $this->CheckOut;
    }
    /**
     * Set CheckOut value
     * @param string $checkOut
     * @return \StructType\BookingTrack
     */
    public function setCheckOut($checkOut = null)
    {
        // validation for constraint: string
        if (!is_null($checkOut) && !is_string($checkOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOut)), __LINE__);
        }
        $this->CheckOut = $checkOut;
        return $this;
    }
    /**
     * Get RoomInfo value
     * @return string|null
     */
    public function getRoomInfo()
    {
        return $this->RoomInfo;
    }
    /**
     * Set RoomInfo value
     * @param string $roomInfo
     * @return \StructType\BookingTrack
     */
    public function setRoomInfo($roomInfo = null)
    {
        // validation for constraint: string
        if (!is_null($roomInfo) && !is_string($roomInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomInfo)), __LINE__);
        }
        $this->RoomInfo = $roomInfo;
        return $this;
    }
    /**
     * Get RateplanId value
     * @return string|null
     */
    public function getRateplanId()
    {
        return $this->RateplanId;
    }
    /**
     * Set RateplanId value
     * @param string $rateplanId
     * @return \StructType\BookingTrack
     */
    public function setRateplanId($rateplanId = null)
    {
        // validation for constraint: string
        if (!is_null($rateplanId) && !is_string($rateplanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateplanId)), __LINE__);
        }
        $this->RateplanId = $rateplanId;
        return $this;
    }
    /**
     * Get RoomTypeID value
     * @return string|null
     */
    public function getRoomTypeID()
    {
        return $this->RoomTypeID;
    }
    /**
     * Set RoomTypeID value
     * @param string $roomTypeID
     * @return \StructType\BookingTrack
     */
    public function setRoomTypeID($roomTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeID) && !is_string($roomTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeID)), __LINE__);
        }
        $this->RoomTypeID = $roomTypeID;
        return $this;
    }
    /**
     * Get Fname value
     * @return string|null
     */
    public function getFname()
    {
        return $this->Fname;
    }
    /**
     * Set Fname value
     * @param string $fname
     * @return \StructType\BookingTrack
     */
    public function setFname($fname = null)
    {
        // validation for constraint: string
        if (!is_null($fname) && !is_string($fname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fname)), __LINE__);
        }
        $this->Fname = $fname;
        return $this;
    }
    /**
     * Get Lname value
     * @return string|null
     */
    public function getLname()
    {
        return $this->Lname;
    }
    /**
     * Set Lname value
     * @param string $lname
     * @return \StructType\BookingTrack
     */
    public function setLname($lname = null)
    {
        // validation for constraint: string
        if (!is_null($lname) && !is_string($lname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lname)), __LINE__);
        }
        $this->Lname = $lname;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\BookingTrack
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\BookingTrack
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\BookingTrack
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\BookingTrack
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\BookingTrack
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\BookingTrack
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\BookingTrack
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingTrack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
