<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentLabel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentLabel
 * @subpackage Structs
 */
class ShipmentLabel extends AbstractStructBase
{
    /**
     * The LabelURL
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LabelURL;
    /**
     * The LabelFileContents
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LabelFileContents;
    /**
     * Constructor method for ShipmentLabel
     * @uses ShipmentLabel::setLabelURL()
     * @uses ShipmentLabel::setLabelFileContents()
     * @param string $labelURL
     * @param string $labelFileContents
     */
    public function __construct($labelURL = null, $labelFileContents = null)
    {
        $this
            ->setLabelURL($labelURL)
            ->setLabelFileContents($labelFileContents);
    }
    /**
     * Get LabelURL value
     * @return string|null
     */
    public function getLabelURL()
    {
        return $this->LabelURL;
    }
    /**
     * Set LabelURL value
     * @param string $labelURL
     * @return \Api\Aramex\Shipping\StructType\ShipmentLabel
     */
    public function setLabelURL($labelURL = null)
    {
        // validation for constraint: string
        if (!is_null($labelURL) && !is_string($labelURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelURL)), __LINE__);
        }
        $this->LabelURL = $labelURL;
        return $this;
    }
    /**
     * Get LabelFileContents value
     * @return string|null
     */
    public function getLabelFileContents()
    {
        return $this->LabelFileContents;
    }
    /**
     * Set LabelFileContents value
     * @param string $labelFileContents
     * @return \Api\Aramex\Shipping\StructType\ShipmentLabel
     */
    public function setLabelFileContents($labelFileContents = null)
    {
        // validation for constraint: string
        if (!is_null($labelFileContents) && !is_string($labelFileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelFileContents)), __LINE__);
        }
        $this->LabelFileContents = $labelFileContents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ShipmentLabel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
