<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentItem
 * @subpackage Structs
 */
class ShipmentItem extends AbstractStructBase
{
    /**
     * The PackageType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PackageType;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Weight
     */
    public $Weight;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * Constructor method for ShipmentItem
     * @uses ShipmentItem::setPackageType()
     * @uses ShipmentItem::setQuantity()
     * @uses ShipmentItem::setWeight()
     * @uses ShipmentItem::setComments()
     * @uses ShipmentItem::setReference()
     * @param string $packageType
     * @param int $quantity
     * @param \Api\Aramex\Shipping\StructType\Weight $weight
     * @param string $comments
     * @param string $reference
     */
    public function __construct($packageType = null, $quantity = null, \Api\Aramex\Shipping\StructType\Weight $weight = null, $comments = null, $reference = null)
    {
        $this
            ->setPackageType($packageType)
            ->setQuantity($quantity)
            ->setWeight($weight)
            ->setComments($comments)
            ->setReference($reference);
    }
    /**
     * Get PackageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @param string $packageType
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageType)), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Weight value
     * @return \Api\Aramex\Shipping\StructType\Weight|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \Api\Aramex\Shipping\StructType\Weight $weight
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem
     */
    public function setWeight(\Api\Aramex\Shipping\StructType\Weight $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get Reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->Reference) ? $this->Reference : null;
    }
    /**
     * Set Reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->Reference);
        } else {
            $this->Reference = $reference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
