<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentDetails
 * @subpackage Structs
 */
class ShipmentDetails extends AbstractStructBase
{
    /**
     * The Dimensions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Dimensions
     */
    public $Dimensions;
    /**
     * The ActualWeight
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Weight
     */
    public $ActualWeight;
    /**
     * The ChargeableWeight
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Weight
     */
    public $ChargeableWeight;
    /**
     * The DescriptionOfGoods
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DescriptionOfGoods;
    /**
     * The GoodsOriginCountry
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GoodsOriginCountry;
    /**
     * The NumberOfPieces
     * @var int
     */
    public $NumberOfPieces;
    /**
     * The ProductGroup
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductGroup;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * The PaymentOptions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentOptions;
    /**
     * The CustomsValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $CustomsValueAmount;
    /**
     * The CashOnDeliveryAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $CashOnDeliveryAmount;
    /**
     * The InsuranceAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $InsuranceAmount;
    /**
     * The CashAdditionalAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $CashAdditionalAmount;
    /**
     * The CashAdditionalAmountDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CashAdditionalAmountDescription;
    /**
     * The CollectAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $CollectAmount;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Services;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem
     */
    public $Items;
    /**
     * Constructor method for ShipmentDetails
     * @uses ShipmentDetails::setDimensions()
     * @uses ShipmentDetails::setActualWeight()
     * @uses ShipmentDetails::setChargeableWeight()
     * @uses ShipmentDetails::setDescriptionOfGoods()
     * @uses ShipmentDetails::setGoodsOriginCountry()
     * @uses ShipmentDetails::setNumberOfPieces()
     * @uses ShipmentDetails::setProductGroup()
     * @uses ShipmentDetails::setProductType()
     * @uses ShipmentDetails::setPaymentType()
     * @uses ShipmentDetails::setPaymentOptions()
     * @uses ShipmentDetails::setCustomsValueAmount()
     * @uses ShipmentDetails::setCashOnDeliveryAmount()
     * @uses ShipmentDetails::setInsuranceAmount()
     * @uses ShipmentDetails::setCashAdditionalAmount()
     * @uses ShipmentDetails::setCashAdditionalAmountDescription()
     * @uses ShipmentDetails::setCollectAmount()
     * @uses ShipmentDetails::setServices()
     * @uses ShipmentDetails::setItems()
     * @param \Api\Aramex\Shipping\StructType\Dimensions $dimensions
     * @param \Api\Aramex\Shipping\StructType\Weight $actualWeight
     * @param \Api\Aramex\Shipping\StructType\Weight $chargeableWeight
     * @param string $descriptionOfGoods
     * @param string $goodsOriginCountry
     * @param int $numberOfPieces
     * @param string $productGroup
     * @param string $productType
     * @param string $paymentType
     * @param string $paymentOptions
     * @param \Api\Aramex\Shipping\StructType\Money $customsValueAmount
     * @param \Api\Aramex\Shipping\StructType\Money $cashOnDeliveryAmount
     * @param \Api\Aramex\Shipping\StructType\Money $insuranceAmount
     * @param \Api\Aramex\Shipping\StructType\Money $cashAdditionalAmount
     * @param string $cashAdditionalAmountDescription
     * @param \Api\Aramex\Shipping\StructType\Money $collectAmount
     * @param string $services
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem $items
     */
    public function __construct(\Api\Aramex\Shipping\StructType\Dimensions $dimensions = null, \Api\Aramex\Shipping\StructType\Weight $actualWeight = null, \Api\Aramex\Shipping\StructType\Weight $chargeableWeight = null, $descriptionOfGoods = null, $goodsOriginCountry = null, $numberOfPieces = null, $productGroup = null, $productType = null, $paymentType = null, $paymentOptions = null, \Api\Aramex\Shipping\StructType\Money $customsValueAmount = null, \Api\Aramex\Shipping\StructType\Money $cashOnDeliveryAmount = null, \Api\Aramex\Shipping\StructType\Money $insuranceAmount = null, \Api\Aramex\Shipping\StructType\Money $cashAdditionalAmount = null, $cashAdditionalAmountDescription = null, \Api\Aramex\Shipping\StructType\Money $collectAmount = null, $services = null, \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem $items = null)
    {
        $this
            ->setDimensions($dimensions)
            ->setActualWeight($actualWeight)
            ->setChargeableWeight($chargeableWeight)
            ->setDescriptionOfGoods($descriptionOfGoods)
            ->setGoodsOriginCountry($goodsOriginCountry)
            ->setNumberOfPieces($numberOfPieces)
            ->setProductGroup($productGroup)
            ->setProductType($productType)
            ->setPaymentType($paymentType)
            ->setPaymentOptions($paymentOptions)
            ->setCustomsValueAmount($customsValueAmount)
            ->setCashOnDeliveryAmount($cashOnDeliveryAmount)
            ->setInsuranceAmount($insuranceAmount)
            ->setCashAdditionalAmount($cashAdditionalAmount)
            ->setCashAdditionalAmountDescription($cashAdditionalAmountDescription)
            ->setCollectAmount($collectAmount)
            ->setServices($services)
            ->setItems($items);
    }
    /**
     * Get Dimensions value
     * @return \Api\Aramex\Shipping\StructType\Dimensions|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Api\Aramex\Shipping\StructType\Dimensions $dimensions
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setDimensions(\Api\Aramex\Shipping\StructType\Dimensions $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get ActualWeight value
     * @return \Api\Aramex\Shipping\StructType\Weight|null
     */
    public function getActualWeight()
    {
        return $this->ActualWeight;
    }
    /**
     * Set ActualWeight value
     * @param \Api\Aramex\Shipping\StructType\Weight $actualWeight
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setActualWeight(\Api\Aramex\Shipping\StructType\Weight $actualWeight = null)
    {
        $this->ActualWeight = $actualWeight;
        return $this;
    }
    /**
     * Get ChargeableWeight value
     * @return \Api\Aramex\Shipping\StructType\Weight|null
     */
    public function getChargeableWeight()
    {
        return $this->ChargeableWeight;
    }
    /**
     * Set ChargeableWeight value
     * @param \Api\Aramex\Shipping\StructType\Weight $chargeableWeight
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setChargeableWeight(\Api\Aramex\Shipping\StructType\Weight $chargeableWeight = null)
    {
        $this->ChargeableWeight = $chargeableWeight;
        return $this;
    }
    /**
     * Get DescriptionOfGoods value
     * @return string|null
     */
    public function getDescriptionOfGoods()
    {
        return $this->DescriptionOfGoods;
    }
    /**
     * Set DescriptionOfGoods value
     * @param string $descriptionOfGoods
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setDescriptionOfGoods($descriptionOfGoods = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionOfGoods) && !is_string($descriptionOfGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptionOfGoods)), __LINE__);
        }
        $this->DescriptionOfGoods = $descriptionOfGoods;
        return $this;
    }
    /**
     * Get GoodsOriginCountry value
     * @return string|null
     */
    public function getGoodsOriginCountry()
    {
        return $this->GoodsOriginCountry;
    }
    /**
     * Set GoodsOriginCountry value
     * @param string $goodsOriginCountry
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setGoodsOriginCountry($goodsOriginCountry = null)
    {
        // validation for constraint: string
        if (!is_null($goodsOriginCountry) && !is_string($goodsOriginCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodsOriginCountry)), __LINE__);
        }
        $this->GoodsOriginCountry = $goodsOriginCountry;
        return $this;
    }
    /**
     * Get NumberOfPieces value
     * @return int|null
     */
    public function getNumberOfPieces()
    {
        return $this->NumberOfPieces;
    }
    /**
     * Set NumberOfPieces value
     * @param int $numberOfPieces
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setNumberOfPieces($numberOfPieces = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPieces) && !is_numeric($numberOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPieces)), __LINE__);
        }
        $this->NumberOfPieces = $numberOfPieces;
        return $this;
    }
    /**
     * Get ProductGroup value
     * @return string|null
     */
    public function getProductGroup()
    {
        return $this->ProductGroup;
    }
    /**
     * Set ProductGroup value
     * @param string $productGroup
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setProductGroup($productGroup = null)
    {
        // validation for constraint: string
        if (!is_null($productGroup) && !is_string($productGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGroup)), __LINE__);
        }
        $this->ProductGroup = $productGroup;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentOptions value
     * @return string|null
     */
    public function getPaymentOptions()
    {
        return $this->PaymentOptions;
    }
    /**
     * Set PaymentOptions value
     * @param string $paymentOptions
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setPaymentOptions($paymentOptions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentOptions) && !is_string($paymentOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentOptions)), __LINE__);
        }
        $this->PaymentOptions = $paymentOptions;
        return $this;
    }
    /**
     * Get CustomsValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getCustomsValueAmount()
    {
        return isset($this->CustomsValueAmount) ? $this->CustomsValueAmount : null;
    }
    /**
     * Set CustomsValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Money $customsValueAmount
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setCustomsValueAmount(\Api\Aramex\Shipping\StructType\Money $customsValueAmount = null)
    {
        if (is_null($customsValueAmount) || (is_array($customsValueAmount) && empty($customsValueAmount))) {
            unset($this->CustomsValueAmount);
        } else {
            $this->CustomsValueAmount = $customsValueAmount;
        }
        return $this;
    }
    /**
     * Get CashOnDeliveryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getCashOnDeliveryAmount()
    {
        return isset($this->CashOnDeliveryAmount) ? $this->CashOnDeliveryAmount : null;
    }
    /**
     * Set CashOnDeliveryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Money $cashOnDeliveryAmount
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setCashOnDeliveryAmount(\Api\Aramex\Shipping\StructType\Money $cashOnDeliveryAmount = null)
    {
        if (is_null($cashOnDeliveryAmount) || (is_array($cashOnDeliveryAmount) && empty($cashOnDeliveryAmount))) {
            unset($this->CashOnDeliveryAmount);
        } else {
            $this->CashOnDeliveryAmount = $cashOnDeliveryAmount;
        }
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getInsuranceAmount()
    {
        return isset($this->InsuranceAmount) ? $this->InsuranceAmount : null;
    }
    /**
     * Set InsuranceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Money $insuranceAmount
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setInsuranceAmount(\Api\Aramex\Shipping\StructType\Money $insuranceAmount = null)
    {
        if (is_null($insuranceAmount) || (is_array($insuranceAmount) && empty($insuranceAmount))) {
            unset($this->InsuranceAmount);
        } else {
            $this->InsuranceAmount = $insuranceAmount;
        }
        return $this;
    }
    /**
     * Get CashAdditionalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getCashAdditionalAmount()
    {
        return isset($this->CashAdditionalAmount) ? $this->CashAdditionalAmount : null;
    }
    /**
     * Set CashAdditionalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Money $cashAdditionalAmount
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setCashAdditionalAmount(\Api\Aramex\Shipping\StructType\Money $cashAdditionalAmount = null)
    {
        if (is_null($cashAdditionalAmount) || (is_array($cashAdditionalAmount) && empty($cashAdditionalAmount))) {
            unset($this->CashAdditionalAmount);
        } else {
            $this->CashAdditionalAmount = $cashAdditionalAmount;
        }
        return $this;
    }
    /**
     * Get CashAdditionalAmountDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCashAdditionalAmountDescription()
    {
        return isset($this->CashAdditionalAmountDescription) ? $this->CashAdditionalAmountDescription : null;
    }
    /**
     * Set CashAdditionalAmountDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cashAdditionalAmountDescription
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setCashAdditionalAmountDescription($cashAdditionalAmountDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cashAdditionalAmountDescription) && !is_string($cashAdditionalAmountDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cashAdditionalAmountDescription)), __LINE__);
        }
        if (is_null($cashAdditionalAmountDescription) || (is_array($cashAdditionalAmountDescription) && empty($cashAdditionalAmountDescription))) {
            unset($this->CashAdditionalAmountDescription);
        } else {
            $this->CashAdditionalAmountDescription = $cashAdditionalAmountDescription;
        }
        return $this;
    }
    /**
     * Get CollectAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getCollectAmount()
    {
        return isset($this->CollectAmount) ? $this->CollectAmount : null;
    }
    /**
     * Set CollectAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Money $collectAmount
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setCollectAmount(\Api\Aramex\Shipping\StructType\Money $collectAmount = null)
    {
        if (is_null($collectAmount) || (is_array($collectAmount) && empty($collectAmount))) {
            unset($this->CollectAmount);
        } else {
            $this->CollectAmount = $collectAmount;
        }
        return $this;
    }
    /**
     * Get Services value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServices()
    {
        return isset($this->Services) ? $this->Services : null;
    }
    /**
     * Set Services value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $services
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setServices($services = null)
    {
        // validation for constraint: string
        if (!is_null($services) && !is_string($services)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($services)), __LINE__);
        }
        if (is_null($services) || (is_array($services) && empty($services))) {
            unset($this->Services);
        } else {
            $this->Services = $services;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem $items
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public function setItems(\Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
