<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentCreationResponse StructType
 * @subpackage Structs
 */
class ShipmentCreationResponse extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Transaction
     */
    public $Transaction;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfNotification
     */
    public $Notifications;
    /**
     * The HasErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrors;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment
     */
    public $Shipments;
    /**
     * Constructor method for ShipmentCreationResponse
     * @uses ShipmentCreationResponse::setTransaction()
     * @uses ShipmentCreationResponse::setNotifications()
     * @uses ShipmentCreationResponse::setHasErrors()
     * @uses ShipmentCreationResponse::setShipments()
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications
     * @param bool $hasErrors
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $shipments
     */
    public function __construct(\Api\Aramex\Shipping\StructType\Transaction $transaction = null, \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications = null, $hasErrors = null, \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $shipments = null)
    {
        $this
            ->setTransaction($transaction)
            ->setNotifications($notifications)
            ->setHasErrors($hasErrors)
            ->setShipments($shipments);
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationResponse
     */
    public function setTransaction(\Api\Aramex\Shipping\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Notifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfNotification|null
     */
    public function getNotifications()
    {
        return isset($this->Notifications) ? $this->Notifications : null;
    }
    /**
     * Set Notifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationResponse
     */
    public function setNotifications(\Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications = null)
    {
        if (is_null($notifications) || (is_array($notifications) && empty($notifications))) {
            unset($this->Notifications);
        } else {
            $this->Notifications = $notifications;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationResponse
     */
    public function setHasErrors($hasErrors = null)
    {
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $shipments
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationResponse
     */
    public function setShipments(\Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
