<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelPrintingResponse StructType
 * @subpackage Structs
 */
class LabelPrintingResponse extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Transaction
     */
    public $Transaction;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfNotification
     */
    public $Notifications;
    /**
     * The HasErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrors;
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The ShipmentLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ShipmentLabel
     */
    public $ShipmentLabel;
    /**
     * Constructor method for LabelPrintingResponse
     * @uses LabelPrintingResponse::setTransaction()
     * @uses LabelPrintingResponse::setNotifications()
     * @uses LabelPrintingResponse::setHasErrors()
     * @uses LabelPrintingResponse::setShipmentNumber()
     * @uses LabelPrintingResponse::setShipmentLabel()
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications
     * @param bool $hasErrors
     * @param string $shipmentNumber
     * @param \Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel
     */
    public function __construct(\Api\Aramex\Shipping\StructType\Transaction $transaction = null, \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications = null, $hasErrors = null, $shipmentNumber = null, \Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel = null)
    {
        $this
            ->setTransaction($transaction)
            ->setNotifications($notifications)
            ->setHasErrors($hasErrors)
            ->setShipmentNumber($shipmentNumber)
            ->setShipmentLabel($shipmentLabel);
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingResponse
     */
    public function setTransaction(\Api\Aramex\Shipping\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Notifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfNotification|null
     */
    public function getNotifications()
    {
        return isset($this->Notifications) ? $this->Notifications : null;
    }
    /**
     * Set Notifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingResponse
     */
    public function setNotifications(\Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications = null)
    {
        if (is_null($notifications) || (is_array($notifications) && empty($notifications))) {
            unset($this->Notifications);
        } else {
            $this->Notifications = $notifications;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingResponse
     */
    public function setHasErrors($hasErrors = null)
    {
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return isset($this->ShipmentNumber) ? $this->ShipmentNumber : null;
    }
    /**
     * Set ShipmentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentNumber
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingResponse
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentNumber)), __LINE__);
        }
        if (is_null($shipmentNumber) || (is_array($shipmentNumber) && empty($shipmentNumber))) {
            unset($this->ShipmentNumber);
        } else {
            $this->ShipmentNumber = $shipmentNumber;
        }
        return $this;
    }
    /**
     * Get ShipmentLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ShipmentLabel|null
     */
    public function getShipmentLabel()
    {
        return isset($this->ShipmentLabel) ? $this->ShipmentLabel : null;
    }
    /**
     * Set ShipmentLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingResponse
     */
    public function setShipmentLabel(\Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel = null)
    {
        if (is_null($shipmentLabel) || (is_array($shipmentLabel) && empty($shipmentLabel))) {
            unset($this->ShipmentLabel);
        } else {
            $this->ShipmentLabel = $shipmentLabel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
