<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelPrintingRequest StructType
 * @subpackage Structs
 */
class LabelPrintingRequest extends AbstractStructBase
{
    /**
     * The ClientInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ClientInfo
     */
    public $ClientInfo;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Transaction
     */
    public $Transaction;
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The ProductGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductGroup;
    /**
     * The OriginEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginEntity;
    /**
     * The LabelInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\LabelInfo
     */
    public $LabelInfo;
    /**
     * Constructor method for LabelPrintingRequest
     * @uses LabelPrintingRequest::setClientInfo()
     * @uses LabelPrintingRequest::setTransaction()
     * @uses LabelPrintingRequest::setShipmentNumber()
     * @uses LabelPrintingRequest::setProductGroup()
     * @uses LabelPrintingRequest::setOriginEntity()
     * @uses LabelPrintingRequest::setLabelInfo()
     * @param \Api\Aramex\Shipping\StructType\ClientInfo $clientInfo
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @param string $shipmentNumber
     * @param string $productGroup
     * @param string $originEntity
     * @param \Api\Aramex\Shipping\StructType\LabelInfo $labelInfo
     */
    public function __construct(\Api\Aramex\Shipping\StructType\ClientInfo $clientInfo = null, \Api\Aramex\Shipping\StructType\Transaction $transaction = null, $shipmentNumber = null, $productGroup = null, $originEntity = null, \Api\Aramex\Shipping\StructType\LabelInfo $labelInfo = null)
    {
        $this
            ->setClientInfo($clientInfo)
            ->setTransaction($transaction)
            ->setShipmentNumber($shipmentNumber)
            ->setProductGroup($productGroup)
            ->setOriginEntity($originEntity)
            ->setLabelInfo($labelInfo);
    }
    /**
     * Get ClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ClientInfo|null
     */
    public function getClientInfo()
    {
        return isset($this->ClientInfo) ? $this->ClientInfo : null;
    }
    /**
     * Set ClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\ClientInfo $clientInfo
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public function setClientInfo(\Api\Aramex\Shipping\StructType\ClientInfo $clientInfo = null)
    {
        if (is_null($clientInfo) || (is_array($clientInfo) && empty($clientInfo))) {
            unset($this->ClientInfo);
        } else {
            $this->ClientInfo = $clientInfo;
        }
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public function setTransaction(\Api\Aramex\Shipping\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return isset($this->ShipmentNumber) ? $this->ShipmentNumber : null;
    }
    /**
     * Set ShipmentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentNumber
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentNumber)), __LINE__);
        }
        if (is_null($shipmentNumber) || (is_array($shipmentNumber) && empty($shipmentNumber))) {
            unset($this->ShipmentNumber);
        } else {
            $this->ShipmentNumber = $shipmentNumber;
        }
        return $this;
    }
    /**
     * Get ProductGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductGroup()
    {
        return isset($this->ProductGroup) ? $this->ProductGroup : null;
    }
    /**
     * Set ProductGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productGroup
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public function setProductGroup($productGroup = null)
    {
        // validation for constraint: string
        if (!is_null($productGroup) && !is_string($productGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGroup)), __LINE__);
        }
        if (is_null($productGroup) || (is_array($productGroup) && empty($productGroup))) {
            unset($this->ProductGroup);
        } else {
            $this->ProductGroup = $productGroup;
        }
        return $this;
    }
    /**
     * Get OriginEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginEntity()
    {
        return isset($this->OriginEntity) ? $this->OriginEntity : null;
    }
    /**
     * Set OriginEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originEntity
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public function setOriginEntity($originEntity = null)
    {
        // validation for constraint: string
        if (!is_null($originEntity) && !is_string($originEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originEntity)), __LINE__);
        }
        if (is_null($originEntity) || (is_array($originEntity) && empty($originEntity))) {
            unset($this->OriginEntity);
        } else {
            $this->OriginEntity = $originEntity;
        }
        return $this;
    }
    /**
     * Get LabelInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\LabelInfo|null
     */
    public function getLabelInfo()
    {
        return isset($this->LabelInfo) ? $this->LabelInfo : null;
    }
    /**
     * Set LabelInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\LabelInfo $labelInfo
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public function setLabelInfo(\Api\Aramex\Shipping\StructType\LabelInfo $labelInfo = null)
    {
        if (is_null($labelInfo) || (is_array($labelInfo) && empty($labelInfo))) {
            unset($this->LabelInfo);
        } else {
            $this->LabelInfo = $labelInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\LabelPrintingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
