<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Api\Aramex\Shipping\ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \Api\Aramex\Shipping\ServiceType\Create($options);
/**
 * Sample call for CreateShipments operation/method
 */
if ($create->CreateShipments(new \Api\Aramex\Shipping\StructType\ShipmentCreationRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePickup operation/method
 */
if ($create->CreatePickup(new \Api\Aramex\Shipping\StructType\PickupCreationRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \Api\Aramex\Shipping\ServiceType\_Print($options);
/**
 * Sample call for PrintLabel operation/method
 */
if ($print->PrintLabel(new \Api\Aramex\Shipping\StructType\LabelPrintingRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \Api\Aramex\Shipping\ServiceType\Cancel($options);
/**
 * Sample call for CancelPickup operation/method
 */
if ($cancel->CancelPickup(new \Api\Aramex\Shipping\StructType\PickupCancelationRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
