<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Weight StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Weight
 * @subpackage Structs
 */
class Weight extends AbstractStructBase
{
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Unit;
    /**
     * The Value
     * @var float
     */
    public $Value;
    /**
     * Constructor method for Weight
     * @uses Weight::setUnit()
     * @uses Weight::setValue()
     * @param string $unit
     * @param float $value
     */
    public function __construct($unit = null, $value = null)
    {
        $this
            ->setUnit($unit)
            ->setValue($value);
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \Api\Aramex\Shipping\StructType\Weight
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \Api\Aramex\Shipping\StructType\Weight
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\Weight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
