<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pickup StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Pickup
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The PickupAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Address
     */
    public $PickupAddress;
    /**
     * The PickupContact
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Contact
     */
    public $PickupContact;
    /**
     * The PickupLocation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PickupLocation;
    /**
     * The PickupDate
     * @var string
     */
    public $PickupDate;
    /**
     * The ReadyTime
     * @var string
     */
    public $ReadyTime;
    /**
     * The LastPickupTime
     * @var string
     */
    public $LastPickupTime;
    /**
     * The ClosingTime
     * @var string
     */
    public $ClosingTime;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference1;
    /**
     * The Reference2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference2;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Vehicle;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfShipment
     */
    public $Shipments;
    /**
     * The PickupItems
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail
     */
    public $PickupItems;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Pickup
     * @uses Pickup::setPickupAddress()
     * @uses Pickup::setPickupContact()
     * @uses Pickup::setPickupLocation()
     * @uses Pickup::setPickupDate()
     * @uses Pickup::setReadyTime()
     * @uses Pickup::setLastPickupTime()
     * @uses Pickup::setClosingTime()
     * @uses Pickup::setComments()
     * @uses Pickup::setReference1()
     * @uses Pickup::setReference2()
     * @uses Pickup::setVehicle()
     * @uses Pickup::setShipments()
     * @uses Pickup::setPickupItems()
     * @uses Pickup::setStatus()
     * @param \Api\Aramex\Shipping\StructType\Address $pickupAddress
     * @param \Api\Aramex\Shipping\StructType\Contact $pickupContact
     * @param string $pickupLocation
     * @param string $pickupDate
     * @param string $readyTime
     * @param string $lastPickupTime
     * @param string $closingTime
     * @param string $comments
     * @param string $reference1
     * @param string $reference2
     * @param string $vehicle
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail $pickupItems
     * @param string $status
     */
    public function __construct(\Api\Aramex\Shipping\StructType\Address $pickupAddress = null, \Api\Aramex\Shipping\StructType\Contact $pickupContact = null, $pickupLocation = null, $pickupDate = null, $readyTime = null, $lastPickupTime = null, $closingTime = null, $comments = null, $reference1 = null, $reference2 = null, $vehicle = null, \Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments = null, \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail $pickupItems = null, $status = null)
    {
        $this
            ->setPickupAddress($pickupAddress)
            ->setPickupContact($pickupContact)
            ->setPickupLocation($pickupLocation)
            ->setPickupDate($pickupDate)
            ->setReadyTime($readyTime)
            ->setLastPickupTime($lastPickupTime)
            ->setClosingTime($closingTime)
            ->setComments($comments)
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setVehicle($vehicle)
            ->setShipments($shipments)
            ->setPickupItems($pickupItems)
            ->setStatus($status);
    }
    /**
     * Get PickupAddress value
     * @return \Api\Aramex\Shipping\StructType\Address|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \Api\Aramex\Shipping\StructType\Address $pickupAddress
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setPickupAddress(\Api\Aramex\Shipping\StructType\Address $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get PickupContact value
     * @return \Api\Aramex\Shipping\StructType\Contact|null
     */
    public function getPickupContact()
    {
        return $this->PickupContact;
    }
    /**
     * Set PickupContact value
     * @param \Api\Aramex\Shipping\StructType\Contact $pickupContact
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setPickupContact(\Api\Aramex\Shipping\StructType\Contact $pickupContact = null)
    {
        $this->PickupContact = $pickupContact;
        return $this;
    }
    /**
     * Get PickupLocation value
     * @return string|null
     */
    public function getPickupLocation()
    {
        return $this->PickupLocation;
    }
    /**
     * Set PickupLocation value
     * @param string $pickupLocation
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setPickupLocation($pickupLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocation) && !is_string($pickupLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupLocation)), __LINE__);
        }
        $this->PickupLocation = $pickupLocation;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get ReadyTime value
     * @return string|null
     */
    public function getReadyTime()
    {
        return $this->ReadyTime;
    }
    /**
     * Set ReadyTime value
     * @param string $readyTime
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setReadyTime($readyTime = null)
    {
        // validation for constraint: string
        if (!is_null($readyTime) && !is_string($readyTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readyTime)), __LINE__);
        }
        $this->ReadyTime = $readyTime;
        return $this;
    }
    /**
     * Get LastPickupTime value
     * @return string|null
     */
    public function getLastPickupTime()
    {
        return $this->LastPickupTime;
    }
    /**
     * Set LastPickupTime value
     * @param string $lastPickupTime
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setLastPickupTime($lastPickupTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastPickupTime) && !is_string($lastPickupTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPickupTime)), __LINE__);
        }
        $this->LastPickupTime = $lastPickupTime;
        return $this;
    }
    /**
     * Get ClosingTime value
     * @return string|null
     */
    public function getClosingTime()
    {
        return $this->ClosingTime;
    }
    /**
     * Set ClosingTime value
     * @param string $closingTime
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setClosingTime($closingTime = null)
    {
        // validation for constraint: string
        if (!is_null($closingTime) && !is_string($closingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closingTime)), __LINE__);
        }
        $this->ClosingTime = $closingTime;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Reference1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference1()
    {
        return isset($this->Reference1) ? $this->Reference1 : null;
    }
    /**
     * Set Reference1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference1
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        if (is_null($reference1) || (is_array($reference1) && empty($reference1))) {
            unset($this->Reference1);
        } else {
            $this->Reference1 = $reference1;
        }
        return $this;
    }
    /**
     * Get Reference2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference2()
    {
        return isset($this->Reference2) ? $this->Reference2 : null;
    }
    /**
     * Set Reference2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference2
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference2)), __LINE__);
        }
        if (is_null($reference2) || (is_array($reference2) && empty($reference2))) {
            unset($this->Reference2);
        } else {
            $this->Reference2 = $reference2;
        }
        return $this;
    }
    /**
     * Get Vehicle value
     * @return string|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param string $vehicle
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setVehicle($vehicle = null)
    {
        // validation for constraint: string
        if (!is_null($vehicle) && !is_string($vehicle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicle)), __LINE__);
        }
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfShipment|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setShipments(\Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get PickupItems value
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail|null
     */
    public function getPickupItems()
    {
        return $this->PickupItems;
    }
    /**
     * Set PickupItems value
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail $pickupItems
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setPickupItems(\Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail $pickupItems = null)
    {
        $this->PickupItems = $pickupItems;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\Pickup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
