<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LabelInfo
 * @subpackage Structs
 */
class LabelInfo extends AbstractStructBase
{
    /**
     * The ReportID
     * @var int
     */
    public $ReportID;
    /**
     * The ReportType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReportType;
    /**
     * Constructor method for LabelInfo
     * @uses LabelInfo::setReportID()
     * @uses LabelInfo::setReportType()
     * @param int $reportID
     * @param string $reportType
     */
    public function __construct($reportID = null, $reportType = null)
    {
        $this
            ->setReportID($reportID)
            ->setReportType($reportType);
    }
    /**
     * Get ReportID value
     * @return int|null
     */
    public function getReportID()
    {
        return $this->ReportID;
    }
    /**
     * Set ReportID value
     * @param int $reportID
     * @return \Api\Aramex\Shipping\StructType\LabelInfo
     */
    public function setReportID($reportID = null)
    {
        // validation for constraint: int
        if (!is_null($reportID) && !is_numeric($reportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportID)), __LINE__);
        }
        $this->ReportID = $reportID;
        return $this;
    }
    /**
     * Get ReportType value
     * @return string|null
     */
    public function getReportType()
    {
        return $this->ReportType;
    }
    /**
     * Set ReportType value
     * @param string $reportType
     * @return \Api\Aramex\Shipping\StructType\LabelInfo
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: string
        if (!is_null($reportType) && !is_string($reportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reportType)), __LINE__);
        }
        $this->ReportType = $reportType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\LabelInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
