<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Attachment
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The FileExtension
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FileExtension;
    /**
     * The FileContents
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FileContents;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setFileName()
     * @uses Attachment::setFileExtension()
     * @uses Attachment::setFileContents()
     * @param string $fileName
     * @param string $fileExtension
     * @param string $fileContents
     */
    public function __construct($fileName = null, $fileExtension = null, $fileContents = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileExtension($fileExtension)
            ->setFileContents($fileContents);
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \Api\Aramex\Shipping\StructType\Attachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileExtension value
     * @return string|null
     */
    public function getFileExtension()
    {
        return $this->FileExtension;
    }
    /**
     * Set FileExtension value
     * @param string $fileExtension
     * @return \Api\Aramex\Shipping\StructType\Attachment
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileExtension)), __LINE__);
        }
        $this->FileExtension = $fileExtension;
        return $this;
    }
    /**
     * Get FileContents value
     * @return string|null
     */
    public function getFileContents()
    {
        return $this->FileContents;
    }
    /**
     * Set FileContents value
     * @param string $fileContents
     * @return \Api\Aramex\Shipping\StructType\Attachment
     */
    public function setFileContents($fileContents = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents) && !is_string($fileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileContents)), __LINE__);
        }
        $this->FileContents = $fileContents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
