<?php

namespace Api\Aramex\Shipping\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateShipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Shipping\StructType\ShipmentCreationRequest $parameters
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationResponse|bool
     */
    public function CreateShipments(\Api\Aramex\Shipping\StructType\ShipmentCreationRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateShipments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Shipping\StructType\PickupCreationRequest $parameters
     * @return \Api\Aramex\Shipping\StructType\PickupCreationResponse|bool
     */
    public function CreatePickup(\Api\Aramex\Shipping\StructType\PickupCreationRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Api\Aramex\Shipping\StructType\PickupCreationResponse|\Api\Aramex\Shipping\StructType\ShipmentCreationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
