<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Shipment
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference1;
    /**
     * The Reference2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference2;
    /**
     * The Reference3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference3;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Party
     */
    public $Shipper;
    /**
     * The Consignee
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Party
     */
    public $Consignee;
    /**
     * The ThirdParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Party
     */
    public $ThirdParty;
    /**
     * The ShippingDateTime
     * @var string
     */
    public $ShippingDateTime;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DueDate;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The PickupLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupLocation;
    /**
     * The OperationsInstructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationsInstructions;
    /**
     * The AccountingInstrcutions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountingInstrcutions;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ShipmentDetails
     */
    public $Details;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment
     */
    public $Attachments;
    /**
     * The ForeignHAWB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignHAWB;
    /**
     * The TransportType_x0020_
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransportType_x0020_;
    /**
     * The PickupGUID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupGUID;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setReference1()
     * @uses Shipment::setReference2()
     * @uses Shipment::setReference3()
     * @uses Shipment::setShipper()
     * @uses Shipment::setConsignee()
     * @uses Shipment::setThirdParty()
     * @uses Shipment::setShippingDateTime()
     * @uses Shipment::setDueDate()
     * @uses Shipment::setComments()
     * @uses Shipment::setPickupLocation()
     * @uses Shipment::setOperationsInstructions()
     * @uses Shipment::setAccountingInstrcutions()
     * @uses Shipment::setDetails()
     * @uses Shipment::setAttachments()
     * @uses Shipment::setForeignHAWB()
     * @uses Shipment::setTransportType_x0020_()
     * @uses Shipment::setPickupGUID()
     * @param string $reference1
     * @param string $reference2
     * @param string $reference3
     * @param \Api\Aramex\Shipping\StructType\Party $shipper
     * @param \Api\Aramex\Shipping\StructType\Party $consignee
     * @param \Api\Aramex\Shipping\StructType\Party $thirdParty
     * @param string $shippingDateTime
     * @param string $dueDate
     * @param string $comments
     * @param string $pickupLocation
     * @param string $operationsInstructions
     * @param string $accountingInstrcutions
     * @param \Api\Aramex\Shipping\StructType\ShipmentDetails $details
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment $attachments
     * @param string $foreignHAWB
     * @param int $transportType_x0020_
     * @param string $pickupGUID
     */
    public function __construct($reference1 = null, $reference2 = null, $reference3 = null, \Api\Aramex\Shipping\StructType\Party $shipper = null, \Api\Aramex\Shipping\StructType\Party $consignee = null, \Api\Aramex\Shipping\StructType\Party $thirdParty = null, $shippingDateTime = null, $dueDate = null, $comments = null, $pickupLocation = null, $operationsInstructions = null, $accountingInstrcutions = null, \Api\Aramex\Shipping\StructType\ShipmentDetails $details = null, \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment $attachments = null, $foreignHAWB = null, $transportType_x0020_ = null, $pickupGUID = null)
    {
        $this
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setReference3($reference3)
            ->setShipper($shipper)
            ->setConsignee($consignee)
            ->setThirdParty($thirdParty)
            ->setShippingDateTime($shippingDateTime)
            ->setDueDate($dueDate)
            ->setComments($comments)
            ->setPickupLocation($pickupLocation)
            ->setOperationsInstructions($operationsInstructions)
            ->setAccountingInstrcutions($accountingInstrcutions)
            ->setDetails($details)
            ->setAttachments($attachments)
            ->setForeignHAWB($foreignHAWB)
            ->setTransportType_x0020_($transportType_x0020_)
            ->setPickupGUID($pickupGUID);
    }
    /**
     * Get Reference1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference1()
    {
        return isset($this->Reference1) ? $this->Reference1 : null;
    }
    /**
     * Set Reference1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference1
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        if (is_null($reference1) || (is_array($reference1) && empty($reference1))) {
            unset($this->Reference1);
        } else {
            $this->Reference1 = $reference1;
        }
        return $this;
    }
    /**
     * Get Reference2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference2()
    {
        return isset($this->Reference2) ? $this->Reference2 : null;
    }
    /**
     * Set Reference2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference2
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference2)), __LINE__);
        }
        if (is_null($reference2) || (is_array($reference2) && empty($reference2))) {
            unset($this->Reference2);
        } else {
            $this->Reference2 = $reference2;
        }
        return $this;
    }
    /**
     * Get Reference3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference3()
    {
        return isset($this->Reference3) ? $this->Reference3 : null;
    }
    /**
     * Set Reference3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference3
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setReference3($reference3 = null)
    {
        // validation for constraint: string
        if (!is_null($reference3) && !is_string($reference3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference3)), __LINE__);
        }
        if (is_null($reference3) || (is_array($reference3) && empty($reference3))) {
            unset($this->Reference3);
        } else {
            $this->Reference3 = $reference3;
        }
        return $this;
    }
    /**
     * Get Shipper value
     * @return \Api\Aramex\Shipping\StructType\Party|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \Api\Aramex\Shipping\StructType\Party $shipper
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setShipper(\Api\Aramex\Shipping\StructType\Party $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get Consignee value
     * @return \Api\Aramex\Shipping\StructType\Party|null
     */
    public function getConsignee()
    {
        return $this->Consignee;
    }
    /**
     * Set Consignee value
     * @param \Api\Aramex\Shipping\StructType\Party $consignee
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setConsignee(\Api\Aramex\Shipping\StructType\Party $consignee = null)
    {
        $this->Consignee = $consignee;
        return $this;
    }
    /**
     * Get ThirdParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Party|null
     */
    public function getThirdParty()
    {
        return isset($this->ThirdParty) ? $this->ThirdParty : null;
    }
    /**
     * Set ThirdParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Party $thirdParty
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setThirdParty(\Api\Aramex\Shipping\StructType\Party $thirdParty = null)
    {
        if (is_null($thirdParty) || (is_array($thirdParty) && empty($thirdParty))) {
            unset($this->ThirdParty);
        } else {
            $this->ThirdParty = $thirdParty;
        }
        return $this;
    }
    /**
     * Get ShippingDateTime value
     * @return string|null
     */
    public function getShippingDateTime()
    {
        return $this->ShippingDateTime;
    }
    /**
     * Set ShippingDateTime value
     * @param string $shippingDateTime
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setShippingDateTime($shippingDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDateTime) && !is_string($shippingDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingDateTime)), __LINE__);
        }
        $this->ShippingDateTime = $shippingDateTime;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get PickupLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupLocation()
    {
        return isset($this->PickupLocation) ? $this->PickupLocation : null;
    }
    /**
     * Set PickupLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupLocation
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setPickupLocation($pickupLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocation) && !is_string($pickupLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupLocation)), __LINE__);
        }
        if (is_null($pickupLocation) || (is_array($pickupLocation) && empty($pickupLocation))) {
            unset($this->PickupLocation);
        } else {
            $this->PickupLocation = $pickupLocation;
        }
        return $this;
    }
    /**
     * Get OperationsInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationsInstructions()
    {
        return isset($this->OperationsInstructions) ? $this->OperationsInstructions : null;
    }
    /**
     * Set OperationsInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationsInstructions
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setOperationsInstructions($operationsInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($operationsInstructions) && !is_string($operationsInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationsInstructions)), __LINE__);
        }
        if (is_null($operationsInstructions) || (is_array($operationsInstructions) && empty($operationsInstructions))) {
            unset($this->OperationsInstructions);
        } else {
            $this->OperationsInstructions = $operationsInstructions;
        }
        return $this;
    }
    /**
     * Get AccountingInstrcutions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountingInstrcutions()
    {
        return isset($this->AccountingInstrcutions) ? $this->AccountingInstrcutions : null;
    }
    /**
     * Set AccountingInstrcutions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountingInstrcutions
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setAccountingInstrcutions($accountingInstrcutions = null)
    {
        // validation for constraint: string
        if (!is_null($accountingInstrcutions) && !is_string($accountingInstrcutions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountingInstrcutions)), __LINE__);
        }
        if (is_null($accountingInstrcutions) || (is_array($accountingInstrcutions) && empty($accountingInstrcutions))) {
            unset($this->AccountingInstrcutions);
        } else {
            $this->AccountingInstrcutions = $accountingInstrcutions;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ShipmentDetails|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\ShipmentDetails $details
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setDetails(\Api\Aramex\Shipping\StructType\ShipmentDetails $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment $attachments
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setAttachments(\Api\Aramex\Shipping\ArrayType\ArrayOfAttachment $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get ForeignHAWB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignHAWB()
    {
        return isset($this->ForeignHAWB) ? $this->ForeignHAWB : null;
    }
    /**
     * Set ForeignHAWB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignHAWB
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setForeignHAWB($foreignHAWB = null)
    {
        // validation for constraint: string
        if (!is_null($foreignHAWB) && !is_string($foreignHAWB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignHAWB)), __LINE__);
        }
        if (is_null($foreignHAWB) || (is_array($foreignHAWB) && empty($foreignHAWB))) {
            unset($this->ForeignHAWB);
        } else {
            $this->ForeignHAWB = $foreignHAWB;
        }
        return $this;
    }
    /**
     * Get TransportType_x0020_ value
     * @return int|null
     */
    public function getTransportType_x0020_()
    {
        return $this->TransportType_x0020_;
    }
    /**
     * Set TransportType_x0020_ value
     * @param int $transportType_x0020_
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setTransportType_x0020_($transportType_x0020_ = null)
    {
        // validation for constraint: int
        if (!is_null($transportType_x0020_) && !is_numeric($transportType_x0020_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transportType_x0020_)), __LINE__);
        }
        $this->TransportType_x0020_ = $transportType_x0020_;
        return $this;
    }
    /**
     * Get PickupGUID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupGUID()
    {
        return isset($this->PickupGUID) ? $this->PickupGUID : null;
    }
    /**
     * Set PickupGUID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupGUID
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public function setPickupGUID($pickupGUID = null)
    {
        // validation for constraint: string
        if (!is_null($pickupGUID) && !is_string($pickupGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupGUID)), __LINE__);
        }
        if (is_null($pickupGUID) || (is_array($pickupGUID) && empty($pickupGUID))) {
            unset($this->PickupGUID);
        } else {
            $this->PickupGUID = $pickupGUID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
