<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessedPickup StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcessedPickup
 * @subpackage Structs
 */
class ProcessedPickup extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The GUID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GUID;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Reference1;
    /**
     * The Reference2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Reference2;
    /**
     * The ProcessedShipments
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment
     */
    public $ProcessedShipments;
    /**
     * Constructor method for ProcessedPickup
     * @uses ProcessedPickup::setID()
     * @uses ProcessedPickup::setGUID()
     * @uses ProcessedPickup::setReference1()
     * @uses ProcessedPickup::setReference2()
     * @uses ProcessedPickup::setProcessedShipments()
     * @param string $iD
     * @param string $gUID
     * @param string $reference1
     * @param string $reference2
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $processedShipments
     */
    public function __construct($iD = null, $gUID = null, $reference1 = null, $reference2 = null, \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $processedShipments = null)
    {
        $this
            ->setID($iD)
            ->setGUID($gUID)
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setProcessedShipments($processedShipments);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Api\Aramex\Shipping\StructType\ProcessedPickup
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get GUID value
     * @return string|null
     */
    public function getGUID()
    {
        return $this->GUID;
    }
    /**
     * Set GUID value
     * @param string $gUID
     * @return \Api\Aramex\Shipping\StructType\ProcessedPickup
     */
    public function setGUID($gUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gUID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $gUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gUID) && !is_string($gUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gUID)), __LINE__);
        }
        $this->GUID = $gUID;
        return $this;
    }
    /**
     * Get Reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->Reference1;
    }
    /**
     * Set Reference1 value
     * @param string $reference1
     * @return \Api\Aramex\Shipping\StructType\ProcessedPickup
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        $this->Reference1 = $reference1;
        return $this;
    }
    /**
     * Get Reference2 value
     * @return string|null
     */
    public function getReference2()
    {
        return $this->Reference2;
    }
    /**
     * Set Reference2 value
     * @param string $reference2
     * @return \Api\Aramex\Shipping\StructType\ProcessedPickup
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference2)), __LINE__);
        }
        $this->Reference2 = $reference2;
        return $this;
    }
    /**
     * Get ProcessedShipments value
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment|null
     */
    public function getProcessedShipments()
    {
        return $this->ProcessedShipments;
    }
    /**
     * Set ProcessedShipments value
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $processedShipments
     * @return \Api\Aramex\Shipping\StructType\ProcessedPickup
     */
    public function setProcessedShipments(\Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment $processedShipments = null)
    {
        $this->ProcessedShipments = $processedShipments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ProcessedPickup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
