<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimensions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Dimensions
 * @subpackage Structs
 */
class Dimensions extends AbstractStructBase
{
    /**
     * The Length
     * @var float
     */
    public $Length;
    /**
     * The Width
     * @var float
     */
    public $Width;
    /**
     * The Height
     * @var float
     */
    public $Height;
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Unit;
    /**
     * Constructor method for Dimensions
     * @uses Dimensions::setLength()
     * @uses Dimensions::setWidth()
     * @uses Dimensions::setHeight()
     * @uses Dimensions::setUnit()
     * @param float $length
     * @param float $width
     * @param float $height
     * @param string $unit
     */
    public function __construct($length = null, $width = null, $height = null, $unit = null)
    {
        $this
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setUnit($unit);
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \Api\Aramex\Shipping\StructType\Dimensions
     */
    public function setLength($length = null)
    {
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \Api\Aramex\Shipping\StructType\Dimensions
     */
    public function setWidth($width = null)
    {
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \Api\Aramex\Shipping\StructType\Dimensions
     */
    public function setHeight($height = null)
    {
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \Api\Aramex\Shipping\StructType\Dimensions
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\Dimensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
