<?php

namespace Api\Aramex\Shipping\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShipmentItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfShipmentItem
 * @subpackage Arrays
 */
class ArrayOfShipmentItem extends AbstractStructArrayBase
{
    /**
     * The ShipmentItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ShipmentItem[]
     */
    public $ShipmentItem;
    /**
     * Constructor method for ArrayOfShipmentItem
     * @uses ArrayOfShipmentItem::setShipmentItem()
     * @param \Api\Aramex\Shipping\StructType\ShipmentItem[] $shipmentItem
     */
    public function __construct(array $shipmentItem = array())
    {
        $this
            ->setShipmentItem($shipmentItem);
    }
    /**
     * Get ShipmentItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem[]|null
     */
    public function getShipmentItem()
    {
        return isset($this->ShipmentItem) ? $this->ShipmentItem : null;
    }
    /**
     * Set ShipmentItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\ShipmentItem[] $shipmentItem
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem
     */
    public function setShipmentItem(array $shipmentItem = array())
    {
        foreach ($shipmentItem as $arrayOfShipmentItemShipmentItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfShipmentItemShipmentItemItem instanceof \Api\Aramex\Shipping\StructType\ShipmentItem) {
                throw new \InvalidArgumentException(sprintf('The ShipmentItem property can only contain items of \Api\Aramex\Shipping\StructType\ShipmentItem, "%s" given', is_object($arrayOfShipmentItemShipmentItemItem) ? get_class($arrayOfShipmentItemShipmentItemItem) : gettype($arrayOfShipmentItemShipmentItemItem)), __LINE__);
            }
        }
        if (is_null($shipmentItem) || (is_array($shipmentItem) && empty($shipmentItem))) {
            unset($this->ShipmentItem);
        } else {
            $this->ShipmentItem = $shipmentItem;
        }
        return $this;
    }
    /**
     * Add item to ShipmentItem value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\ShipmentItem $item
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem
     */
    public function addToShipmentItem(\Api\Aramex\Shipping\StructType\ShipmentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Shipping\StructType\ShipmentItem) {
            throw new \InvalidArgumentException(sprintf('The ShipmentItem property can only contain items of \Api\Aramex\Shipping\StructType\ShipmentItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Shipping\StructType\ShipmentItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShipmentItem
     */
    public function getAttributeName()
    {
        return 'ShipmentItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfShipmentItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
