<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentCreationRequest StructType
 * @subpackage Structs
 */
class ShipmentCreationRequest extends AbstractStructBase
{
    /**
     * The ClientInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ClientInfo
     */
    public $ClientInfo;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Transaction
     */
    public $Transaction;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfShipment
     */
    public $Shipments;
    /**
     * The LabelInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\LabelInfo
     */
    public $LabelInfo;
    /**
     * Constructor method for ShipmentCreationRequest
     * @uses ShipmentCreationRequest::setClientInfo()
     * @uses ShipmentCreationRequest::setTransaction()
     * @uses ShipmentCreationRequest::setShipments()
     * @uses ShipmentCreationRequest::setLabelInfo()
     * @param \Api\Aramex\Shipping\StructType\ClientInfo $clientInfo
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments
     * @param \Api\Aramex\Shipping\StructType\LabelInfo $labelInfo
     */
    public function __construct(\Api\Aramex\Shipping\StructType\ClientInfo $clientInfo = null, \Api\Aramex\Shipping\StructType\Transaction $transaction = null, \Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments = null, \Api\Aramex\Shipping\StructType\LabelInfo $labelInfo = null)
    {
        $this
            ->setClientInfo($clientInfo)
            ->setTransaction($transaction)
            ->setShipments($shipments)
            ->setLabelInfo($labelInfo);
    }
    /**
     * Get ClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ClientInfo|null
     */
    public function getClientInfo()
    {
        return isset($this->ClientInfo) ? $this->ClientInfo : null;
    }
    /**
     * Set ClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\ClientInfo $clientInfo
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationRequest
     */
    public function setClientInfo(\Api\Aramex\Shipping\StructType\ClientInfo $clientInfo = null)
    {
        if (is_null($clientInfo) || (is_array($clientInfo) && empty($clientInfo))) {
            unset($this->ClientInfo);
        } else {
            $this->ClientInfo = $clientInfo;
        }
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationRequest
     */
    public function setTransaction(\Api\Aramex\Shipping\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfShipment|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationRequest
     */
    public function setShipments(\Api\Aramex\Shipping\ArrayType\ArrayOfShipment $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get LabelInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\LabelInfo|null
     */
    public function getLabelInfo()
    {
        return isset($this->LabelInfo) ? $this->LabelInfo : null;
    }
    /**
     * Set LabelInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\LabelInfo $labelInfo
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationRequest
     */
    public function setLabelInfo(\Api\Aramex\Shipping\StructType\LabelInfo $labelInfo = null)
    {
        if (is_null($labelInfo) || (is_array($labelInfo) && empty($labelInfo))) {
            unset($this->LabelInfo);
        } else {
            $this->LabelInfo = $labelInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ShipmentCreationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
