<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessedShipment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcessedShipment
 * @subpackage Structs
 */
class ProcessedShipment extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Reference1;
    /**
     * The Reference2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Reference2;
    /**
     * The Reference3
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Reference3;
    /**
     * The ForeignHAWB
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ForeignHAWB;
    /**
     * The HasErrors
     * @var bool
     */
    public $HasErrors;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\ArrayType\ArrayOfNotification
     */
    public $Notifications;
    /**
     * The ShipmentLabel
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ShipmentLabel
     */
    public $ShipmentLabel;
    /**
     * Constructor method for ProcessedShipment
     * @uses ProcessedShipment::setID()
     * @uses ProcessedShipment::setReference1()
     * @uses ProcessedShipment::setReference2()
     * @uses ProcessedShipment::setReference3()
     * @uses ProcessedShipment::setForeignHAWB()
     * @uses ProcessedShipment::setHasErrors()
     * @uses ProcessedShipment::setNotifications()
     * @uses ProcessedShipment::setShipmentLabel()
     * @param string $iD
     * @param string $reference1
     * @param string $reference2
     * @param string $reference3
     * @param string $foreignHAWB
     * @param bool $hasErrors
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications
     * @param \Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel
     */
    public function __construct($iD = null, $reference1 = null, $reference2 = null, $reference3 = null, $foreignHAWB = null, $hasErrors = null, \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications = null, \Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel = null)
    {
        $this
            ->setID($iD)
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setReference3($reference3)
            ->setForeignHAWB($foreignHAWB)
            ->setHasErrors($hasErrors)
            ->setNotifications($notifications)
            ->setShipmentLabel($shipmentLabel);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->Reference1;
    }
    /**
     * Set Reference1 value
     * @param string $reference1
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        $this->Reference1 = $reference1;
        return $this;
    }
    /**
     * Get Reference2 value
     * @return string|null
     */
    public function getReference2()
    {
        return $this->Reference2;
    }
    /**
     * Set Reference2 value
     * @param string $reference2
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference2)), __LINE__);
        }
        $this->Reference2 = $reference2;
        return $this;
    }
    /**
     * Get Reference3 value
     * @return string|null
     */
    public function getReference3()
    {
        return $this->Reference3;
    }
    /**
     * Set Reference3 value
     * @param string $reference3
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setReference3($reference3 = null)
    {
        // validation for constraint: string
        if (!is_null($reference3) && !is_string($reference3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference3)), __LINE__);
        }
        $this->Reference3 = $reference3;
        return $this;
    }
    /**
     * Get ForeignHAWB value
     * @return string|null
     */
    public function getForeignHAWB()
    {
        return $this->ForeignHAWB;
    }
    /**
     * Set ForeignHAWB value
     * @param string $foreignHAWB
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setForeignHAWB($foreignHAWB = null)
    {
        // validation for constraint: string
        if (!is_null($foreignHAWB) && !is_string($foreignHAWB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignHAWB)), __LINE__);
        }
        $this->ForeignHAWB = $foreignHAWB;
        return $this;
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setHasErrors($hasErrors = null)
    {
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfNotification|null
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * Set Notifications value
     * @param \Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setNotifications(\Api\Aramex\Shipping\ArrayType\ArrayOfNotification $notifications = null)
    {
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Get ShipmentLabel value
     * @return \Api\Aramex\Shipping\StructType\ShipmentLabel|null
     */
    public function getShipmentLabel()
    {
        return $this->ShipmentLabel;
    }
    /**
     * Set ShipmentLabel value
     * @param \Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public function setShipmentLabel(\Api\Aramex\Shipping\StructType\ShipmentLabel $shipmentLabel = null)
    {
        $this->ShipmentLabel = $shipmentLabel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
