<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupItemDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PickupItemDetail
 * @subpackage Structs
 */
class PickupItemDetail extends AbstractStructBase
{
    /**
     * The ProductGroup
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductGroup;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The NumberOfShipments
     * @var int
     */
    public $NumberOfShipments;
    /**
     * The PackageType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PackageType;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Payment;
    /**
     * The ShipmentWeight
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Weight
     */
    public $ShipmentWeight;
    /**
     * The ShipmentVolume
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Volume
     */
    public $ShipmentVolume;
    /**
     * The NumberOfPieces
     * @var int
     */
    public $NumberOfPieces;
    /**
     * The CashAmount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $CashAmount;
    /**
     * The ExtraCharges
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Money
     */
    public $ExtraCharges;
    /**
     * The ShipmentDimensions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Dimensions
     */
    public $ShipmentDimensions;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for PickupItemDetail
     * @uses PickupItemDetail::setProductGroup()
     * @uses PickupItemDetail::setProductType()
     * @uses PickupItemDetail::setNumberOfShipments()
     * @uses PickupItemDetail::setPackageType()
     * @uses PickupItemDetail::setPayment()
     * @uses PickupItemDetail::setShipmentWeight()
     * @uses PickupItemDetail::setShipmentVolume()
     * @uses PickupItemDetail::setNumberOfPieces()
     * @uses PickupItemDetail::setCashAmount()
     * @uses PickupItemDetail::setExtraCharges()
     * @uses PickupItemDetail::setShipmentDimensions()
     * @uses PickupItemDetail::setComments()
     * @param string $productGroup
     * @param string $productType
     * @param int $numberOfShipments
     * @param string $packageType
     * @param string $payment
     * @param \Api\Aramex\Shipping\StructType\Weight $shipmentWeight
     * @param \Api\Aramex\Shipping\StructType\Volume $shipmentVolume
     * @param int $numberOfPieces
     * @param \Api\Aramex\Shipping\StructType\Money $cashAmount
     * @param \Api\Aramex\Shipping\StructType\Money $extraCharges
     * @param \Api\Aramex\Shipping\StructType\Dimensions $shipmentDimensions
     * @param string $comments
     */
    public function __construct($productGroup = null, $productType = null, $numberOfShipments = null, $packageType = null, $payment = null, \Api\Aramex\Shipping\StructType\Weight $shipmentWeight = null, \Api\Aramex\Shipping\StructType\Volume $shipmentVolume = null, $numberOfPieces = null, \Api\Aramex\Shipping\StructType\Money $cashAmount = null, \Api\Aramex\Shipping\StructType\Money $extraCharges = null, \Api\Aramex\Shipping\StructType\Dimensions $shipmentDimensions = null, $comments = null)
    {
        $this
            ->setProductGroup($productGroup)
            ->setProductType($productType)
            ->setNumberOfShipments($numberOfShipments)
            ->setPackageType($packageType)
            ->setPayment($payment)
            ->setShipmentWeight($shipmentWeight)
            ->setShipmentVolume($shipmentVolume)
            ->setNumberOfPieces($numberOfPieces)
            ->setCashAmount($cashAmount)
            ->setExtraCharges($extraCharges)
            ->setShipmentDimensions($shipmentDimensions)
            ->setComments($comments);
    }
    /**
     * Get ProductGroup value
     * @return string|null
     */
    public function getProductGroup()
    {
        return $this->ProductGroup;
    }
    /**
     * Set ProductGroup value
     * @param string $productGroup
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setProductGroup($productGroup = null)
    {
        // validation for constraint: string
        if (!is_null($productGroup) && !is_string($productGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGroup)), __LINE__);
        }
        $this->ProductGroup = $productGroup;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get NumberOfShipments value
     * @return int|null
     */
    public function getNumberOfShipments()
    {
        return $this->NumberOfShipments;
    }
    /**
     * Set NumberOfShipments value
     * @param int $numberOfShipments
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setNumberOfShipments($numberOfShipments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfShipments) && !is_numeric($numberOfShipments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfShipments)), __LINE__);
        }
        $this->NumberOfShipments = $numberOfShipments;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @param string $packageType
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageType)), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get Payment value
     * @return string|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param string $payment
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setPayment($payment = null)
    {
        // validation for constraint: string
        if (!is_null($payment) && !is_string($payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment)), __LINE__);
        }
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get ShipmentWeight value
     * @return \Api\Aramex\Shipping\StructType\Weight|null
     */
    public function getShipmentWeight()
    {
        return $this->ShipmentWeight;
    }
    /**
     * Set ShipmentWeight value
     * @param \Api\Aramex\Shipping\StructType\Weight $shipmentWeight
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setShipmentWeight(\Api\Aramex\Shipping\StructType\Weight $shipmentWeight = null)
    {
        $this->ShipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get ShipmentVolume value
     * @return \Api\Aramex\Shipping\StructType\Volume|null
     */
    public function getShipmentVolume()
    {
        return $this->ShipmentVolume;
    }
    /**
     * Set ShipmentVolume value
     * @param \Api\Aramex\Shipping\StructType\Volume $shipmentVolume
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setShipmentVolume(\Api\Aramex\Shipping\StructType\Volume $shipmentVolume = null)
    {
        $this->ShipmentVolume = $shipmentVolume;
        return $this;
    }
    /**
     * Get NumberOfPieces value
     * @return int|null
     */
    public function getNumberOfPieces()
    {
        return $this->NumberOfPieces;
    }
    /**
     * Set NumberOfPieces value
     * @param int $numberOfPieces
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setNumberOfPieces($numberOfPieces = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPieces) && !is_numeric($numberOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPieces)), __LINE__);
        }
        $this->NumberOfPieces = $numberOfPieces;
        return $this;
    }
    /**
     * Get CashAmount value
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getCashAmount()
    {
        return $this->CashAmount;
    }
    /**
     * Set CashAmount value
     * @param \Api\Aramex\Shipping\StructType\Money $cashAmount
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setCashAmount(\Api\Aramex\Shipping\StructType\Money $cashAmount = null)
    {
        $this->CashAmount = $cashAmount;
        return $this;
    }
    /**
     * Get ExtraCharges value
     * @return \Api\Aramex\Shipping\StructType\Money|null
     */
    public function getExtraCharges()
    {
        return $this->ExtraCharges;
    }
    /**
     * Set ExtraCharges value
     * @param \Api\Aramex\Shipping\StructType\Money $extraCharges
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setExtraCharges(\Api\Aramex\Shipping\StructType\Money $extraCharges = null)
    {
        $this->ExtraCharges = $extraCharges;
        return $this;
    }
    /**
     * Get ShipmentDimensions value
     * @return \Api\Aramex\Shipping\StructType\Dimensions|null
     */
    public function getShipmentDimensions()
    {
        return $this->ShipmentDimensions;
    }
    /**
     * Set ShipmentDimensions value
     * @param \Api\Aramex\Shipping\StructType\Dimensions $shipmentDimensions
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setShipmentDimensions(\Api\Aramex\Shipping\StructType\Dimensions $shipmentDimensions = null)
    {
        $this->ShipmentDimensions = $shipmentDimensions;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
