<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupCancelationRequest StructType
 * @subpackage Structs
 */
class PickupCancelationRequest extends AbstractStructBase
{
    /**
     * The ClientInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ClientInfo
     */
    public $ClientInfo;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Transaction
     */
    public $Transaction;
    /**
     * The PickupGUID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupGUID;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for PickupCancelationRequest
     * @uses PickupCancelationRequest::setClientInfo()
     * @uses PickupCancelationRequest::setTransaction()
     * @uses PickupCancelationRequest::setPickupGUID()
     * @uses PickupCancelationRequest::setComments()
     * @param \Api\Aramex\Shipping\StructType\ClientInfo $clientInfo
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @param string $pickupGUID
     * @param string $comments
     */
    public function __construct(\Api\Aramex\Shipping\StructType\ClientInfo $clientInfo = null, \Api\Aramex\Shipping\StructType\Transaction $transaction = null, $pickupGUID = null, $comments = null)
    {
        $this
            ->setClientInfo($clientInfo)
            ->setTransaction($transaction)
            ->setPickupGUID($pickupGUID)
            ->setComments($comments);
    }
    /**
     * Get ClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ClientInfo|null
     */
    public function getClientInfo()
    {
        return isset($this->ClientInfo) ? $this->ClientInfo : null;
    }
    /**
     * Set ClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\ClientInfo $clientInfo
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationRequest
     */
    public function setClientInfo(\Api\Aramex\Shipping\StructType\ClientInfo $clientInfo = null)
    {
        if (is_null($clientInfo) || (is_array($clientInfo) && empty($clientInfo))) {
            unset($this->ClientInfo);
        } else {
            $this->ClientInfo = $clientInfo;
        }
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Shipping\StructType\Transaction $transaction
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationRequest
     */
    public function setTransaction(\Api\Aramex\Shipping\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get PickupGUID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupGUID()
    {
        return isset($this->PickupGUID) ? $this->PickupGUID : null;
    }
    /**
     * Set PickupGUID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupGUID
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationRequest
     */
    public function setPickupGUID($pickupGUID = null)
    {
        // validation for constraint: string
        if (!is_null($pickupGUID) && !is_string($pickupGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupGUID)), __LINE__);
        }
        if (is_null($pickupGUID) || (is_array($pickupGUID) && empty($pickupGUID))) {
            unset($this->PickupGUID);
        } else {
            $this->PickupGUID = $pickupGUID;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationRequest
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
