<?php

namespace Api\Aramex\Shipping\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Party StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Party
 * @subpackage Structs
 */
class Party extends AbstractStructBase
{
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference1;
    /**
     * The Reference2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference2;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The PartyAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Address
     */
    public $PartyAddress;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Contact
     */
    public $Contact;
    /**
     * Constructor method for Party
     * @uses Party::setReference1()
     * @uses Party::setReference2()
     * @uses Party::setAccountNumber()
     * @uses Party::setPartyAddress()
     * @uses Party::setContact()
     * @param string $reference1
     * @param string $reference2
     * @param string $accountNumber
     * @param \Api\Aramex\Shipping\StructType\Address $partyAddress
     * @param \Api\Aramex\Shipping\StructType\Contact $contact
     */
    public function __construct($reference1 = null, $reference2 = null, $accountNumber = null, \Api\Aramex\Shipping\StructType\Address $partyAddress = null, \Api\Aramex\Shipping\StructType\Contact $contact = null)
    {
        $this
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setAccountNumber($accountNumber)
            ->setPartyAddress($partyAddress)
            ->setContact($contact);
    }
    /**
     * Get Reference1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference1()
    {
        return isset($this->Reference1) ? $this->Reference1 : null;
    }
    /**
     * Set Reference1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference1
     * @return \Api\Aramex\Shipping\StructType\Party
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        if (is_null($reference1) || (is_array($reference1) && empty($reference1))) {
            unset($this->Reference1);
        } else {
            $this->Reference1 = $reference1;
        }
        return $this;
    }
    /**
     * Get Reference2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference2()
    {
        return isset($this->Reference2) ? $this->Reference2 : null;
    }
    /**
     * Set Reference2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference2
     * @return \Api\Aramex\Shipping\StructType\Party
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference2)), __LINE__);
        }
        if (is_null($reference2) || (is_array($reference2) && empty($reference2))) {
            unset($this->Reference2);
        } else {
            $this->Reference2 = $reference2;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \Api\Aramex\Shipping\StructType\Party
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get PartyAddress value
     * @return \Api\Aramex\Shipping\StructType\Address|null
     */
    public function getPartyAddress()
    {
        return $this->PartyAddress;
    }
    /**
     * Set PartyAddress value
     * @param \Api\Aramex\Shipping\StructType\Address $partyAddress
     * @return \Api\Aramex\Shipping\StructType\Party
     */
    public function setPartyAddress(\Api\Aramex\Shipping\StructType\Address $partyAddress = null)
    {
        $this->PartyAddress = $partyAddress;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Api\Aramex\Shipping\StructType\Contact|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Api\Aramex\Shipping\StructType\Contact $contact
     * @return \Api\Aramex\Shipping\StructType\Party
     */
    public function setContact(\Api\Aramex\Shipping\StructType\Contact $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\StructType\Party
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
