<?php

namespace Api\Aramex\Shipping\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Shipping\StructType\PickupCancelationRequest $parameters
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationResponse|bool
     */
    public function CancelPickup(\Api\Aramex\Shipping\StructType\PickupCancelationRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Api\Aramex\Shipping\StructType\PickupCancelationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
