<?php

namespace Api\Aramex\Shipping\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProcessedShipment ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProcessedShipment
 * @subpackage Arrays
 */
class ArrayOfProcessedShipment extends AbstractStructArrayBase
{
    /**
     * The ProcessedShipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\ProcessedShipment[]
     */
    public $ProcessedShipment;
    /**
     * Constructor method for ArrayOfProcessedShipment
     * @uses ArrayOfProcessedShipment::setProcessedShipment()
     * @param \Api\Aramex\Shipping\StructType\ProcessedShipment[] $processedShipment
     */
    public function __construct(array $processedShipment = array())
    {
        $this
            ->setProcessedShipment($processedShipment);
    }
    /**
     * Get ProcessedShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment[]|null
     */
    public function getProcessedShipment()
    {
        return isset($this->ProcessedShipment) ? $this->ProcessedShipment : null;
    }
    /**
     * Set ProcessedShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\ProcessedShipment[] $processedShipment
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment
     */
    public function setProcessedShipment(array $processedShipment = array())
    {
        foreach ($processedShipment as $arrayOfProcessedShipmentProcessedShipmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfProcessedShipmentProcessedShipmentItem instanceof \Api\Aramex\Shipping\StructType\ProcessedShipment) {
                throw new \InvalidArgumentException(sprintf('The ProcessedShipment property can only contain items of \Api\Aramex\Shipping\StructType\ProcessedShipment, "%s" given', is_object($arrayOfProcessedShipmentProcessedShipmentItem) ? get_class($arrayOfProcessedShipmentProcessedShipmentItem) : gettype($arrayOfProcessedShipmentProcessedShipmentItem)), __LINE__);
            }
        }
        if (is_null($processedShipment) || (is_array($processedShipment) && empty($processedShipment))) {
            unset($this->ProcessedShipment);
        } else {
            $this->ProcessedShipment = $processedShipment;
        }
        return $this;
    }
    /**
     * Add item to ProcessedShipment value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\ProcessedShipment $item
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment
     */
    public function addToProcessedShipment(\Api\Aramex\Shipping\StructType\ProcessedShipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Shipping\StructType\ProcessedShipment) {
            throw new \InvalidArgumentException(sprintf('The ProcessedShipment property can only contain items of \Api\Aramex\Shipping\StructType\ProcessedShipment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProcessedShipment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Shipping\StructType\ProcessedShipment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProcessedShipment
     */
    public function getAttributeName()
    {
        return 'ProcessedShipment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfProcessedShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
