<?php

namespace Api\Aramex\Shipping\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPickupItemDetail ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPickupItemDetail
 * @subpackage Arrays
 */
class ArrayOfPickupItemDetail extends AbstractStructArrayBase
{
    /**
     * The PickupItemDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\PickupItemDetail[]
     */
    public $PickupItemDetail;
    /**
     * Constructor method for ArrayOfPickupItemDetail
     * @uses ArrayOfPickupItemDetail::setPickupItemDetail()
     * @param \Api\Aramex\Shipping\StructType\PickupItemDetail[] $pickupItemDetail
     */
    public function __construct(array $pickupItemDetail = array())
    {
        $this
            ->setPickupItemDetail($pickupItemDetail);
    }
    /**
     * Get PickupItemDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail[]|null
     */
    public function getPickupItemDetail()
    {
        return isset($this->PickupItemDetail) ? $this->PickupItemDetail : null;
    }
    /**
     * Set PickupItemDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\PickupItemDetail[] $pickupItemDetail
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail
     */
    public function setPickupItemDetail(array $pickupItemDetail = array())
    {
        foreach ($pickupItemDetail as $arrayOfPickupItemDetailPickupItemDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfPickupItemDetailPickupItemDetailItem instanceof \Api\Aramex\Shipping\StructType\PickupItemDetail) {
                throw new \InvalidArgumentException(sprintf('The PickupItemDetail property can only contain items of \Api\Aramex\Shipping\StructType\PickupItemDetail, "%s" given', is_object($arrayOfPickupItemDetailPickupItemDetailItem) ? get_class($arrayOfPickupItemDetailPickupItemDetailItem) : gettype($arrayOfPickupItemDetailPickupItemDetailItem)), __LINE__);
            }
        }
        if (is_null($pickupItemDetail) || (is_array($pickupItemDetail) && empty($pickupItemDetail))) {
            unset($this->PickupItemDetail);
        } else {
            $this->PickupItemDetail = $pickupItemDetail;
        }
        return $this;
    }
    /**
     * Add item to PickupItemDetail value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\PickupItemDetail $item
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail
     */
    public function addToPickupItemDetail(\Api\Aramex\Shipping\StructType\PickupItemDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Shipping\StructType\PickupItemDetail) {
            throw new \InvalidArgumentException(sprintf('The PickupItemDetail property can only contain items of \Api\Aramex\Shipping\StructType\PickupItemDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PickupItemDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Shipping\StructType\PickupItemDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PickupItemDetail
     */
    public function getAttributeName()
    {
        return 'PickupItemDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfPickupItemDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
