<?php

namespace Api\Aramex\Shipping\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAttachment ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAttachment
 * @subpackage Arrays
 */
class ArrayOfAttachment extends AbstractStructArrayBase
{
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Shipping\StructType\Attachment[]
     */
    public $Attachment;
    /**
     * Constructor method for ArrayOfAttachment
     * @uses ArrayOfAttachment::setAttachment()
     * @param \Api\Aramex\Shipping\StructType\Attachment[] $attachment
     */
    public function __construct(array $attachment = array())
    {
        $this
            ->setAttachment($attachment);
    }
    /**
     * Get Attachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Shipping\StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return isset($this->Attachment) ? $this->Attachment : null;
    }
    /**
     * Set Attachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\Attachment[] $attachment
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $arrayOfAttachmentAttachmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfAttachmentAttachmentItem instanceof \Api\Aramex\Shipping\StructType\Attachment) {
                throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \Api\Aramex\Shipping\StructType\Attachment, "%s" given', is_object($arrayOfAttachmentAttachmentItem) ? get_class($arrayOfAttachmentAttachmentItem) : gettype($arrayOfAttachmentAttachmentItem)), __LINE__);
            }
        }
        if (is_null($attachment) || (is_array($attachment) && empty($attachment))) {
            unset($this->Attachment);
        } else {
            $this->Attachment = $attachment;
        }
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Shipping\StructType\Attachment $item
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment
     */
    public function addToAttachment(\Api\Aramex\Shipping\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Shipping\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \Api\Aramex\Shipping\StructType\Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Shipping\StructType\Attachment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Shipping\StructType\Attachment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Shipping\StructType\Attachment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Shipping\StructType\Attachment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Shipping\StructType\Attachment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Attachment
     */
    public function getAttributeName()
    {
        return 'Attachment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Shipping\ArrayType\ArrayOfAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
