<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://metrolive.telenor.no/kapaks-facade-soap-web/services/KapaksFacade70SoapWrapper/wsdl/KapaksFacade70SoapWrapper.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://metrolive.telenor.no/kapaks-facade-soap-web/services/KapaksFacade70SoapWrapper/wsdl/KapaksFacade70SoapWrapper.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \kapaks\ClassMap::get(),
);
/**
 * Samples for Validate ServiceType
 */
$validate = new \kapaks\ServiceType\Validate($options);
/**
 * Sample call for validateProductSoap operation/method
 */
if ($validate->validateProductSoap(new \kapaks\StructType\ValidateProductSoap()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for validateRelocationSoap operation/method
 */
if ($validate->validateRelocationSoap(new \kapaks\StructType\ValidateRelocationSoap()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \kapaks\ServiceType\Ping($options);
/**
 * Sample call for ping operation/method
 */
if ($ping->ping(new \kapaks\StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Deep ServiceType
 */
$deep = new \kapaks\ServiceType\Deep($options);
/**
 * Sample call for deepPing operation/method
 */
if ($deep->deepPing(new \kapaks\StructType\DeepPing()) !== false) {
    print_r($deep->getResult());
} else {
    print_r($deep->getLastError());
}
