<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WimaxEquipment StructType
 * @subpackage Structs
 */
class WimaxEquipment extends AbstractStructBase
{
    /**
     * The basestationId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $basestationId;
    /**
     * The distance
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $distance;
    /**
     * The sectorId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sectorId;
    /**
     * The sectorFree
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $sectorFree;
    /**
     * The ssEquipmentId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ssEquipmentId;
    /**
     * The ssEquipmentStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ssEquipmentStatus;
    /**
     * The nitraEquipmentId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nitraEquipmentId;
    /**
     * Constructor method for WimaxEquipment
     * @uses WimaxEquipment::setBasestationId()
     * @uses WimaxEquipment::setDistance()
     * @uses WimaxEquipment::setSectorId()
     * @uses WimaxEquipment::setSectorFree()
     * @uses WimaxEquipment::setSsEquipmentId()
     * @uses WimaxEquipment::setSsEquipmentStatus()
     * @uses WimaxEquipment::setNitraEquipmentId()
     * @param string $basestationId
     * @param int $distance
     * @param string $sectorId
     * @param int $sectorFree
     * @param string $ssEquipmentId
     * @param string $ssEquipmentStatus
     * @param string $nitraEquipmentId
     */
    public function __construct($basestationId = null, $distance = null, $sectorId = null, $sectorFree = null, $ssEquipmentId = null, $ssEquipmentStatus = null, $nitraEquipmentId = null)
    {
        $this
            ->setBasestationId($basestationId)
            ->setDistance($distance)
            ->setSectorId($sectorId)
            ->setSectorFree($sectorFree)
            ->setSsEquipmentId($ssEquipmentId)
            ->setSsEquipmentStatus($ssEquipmentStatus)
            ->setNitraEquipmentId($nitraEquipmentId);
    }
    /**
     * Get basestationId value
     * @return string|null
     */
    public function getBasestationId()
    {
        return $this->basestationId;
    }
    /**
     * Set basestationId value
     * @param string $basestationId
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setBasestationId($basestationId = null)
    {
        // validation for constraint: string
        if (!is_null($basestationId) && !is_string($basestationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basestationId)), __LINE__);
        }
        $this->basestationId = $basestationId;
        return $this;
    }
    /**
     * Get distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param int $distance
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get sectorId value
     * @return string|null
     */
    public function getSectorId()
    {
        return $this->sectorId;
    }
    /**
     * Set sectorId value
     * @param string $sectorId
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sectorId)), __LINE__);
        }
        $this->sectorId = $sectorId;
        return $this;
    }
    /**
     * Get sectorFree value
     * @return int|null
     */
    public function getSectorFree()
    {
        return $this->sectorFree;
    }
    /**
     * Set sectorFree value
     * @param int $sectorFree
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setSectorFree($sectorFree = null)
    {
        // validation for constraint: int
        if (!is_null($sectorFree) && !is_numeric($sectorFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sectorFree)), __LINE__);
        }
        $this->sectorFree = $sectorFree;
        return $this;
    }
    /**
     * Get ssEquipmentId value
     * @return string|null
     */
    public function getSsEquipmentId()
    {
        return $this->ssEquipmentId;
    }
    /**
     * Set ssEquipmentId value
     * @param string $ssEquipmentId
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setSsEquipmentId($ssEquipmentId = null)
    {
        // validation for constraint: string
        if (!is_null($ssEquipmentId) && !is_string($ssEquipmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssEquipmentId)), __LINE__);
        }
        $this->ssEquipmentId = $ssEquipmentId;
        return $this;
    }
    /**
     * Get ssEquipmentStatus value
     * @return string|null
     */
    public function getSsEquipmentStatus()
    {
        return $this->ssEquipmentStatus;
    }
    /**
     * Set ssEquipmentStatus value
     * @param string $ssEquipmentStatus
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setSsEquipmentStatus($ssEquipmentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($ssEquipmentStatus) && !is_string($ssEquipmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssEquipmentStatus)), __LINE__);
        }
        $this->ssEquipmentStatus = $ssEquipmentStatus;
        return $this;
    }
    /**
     * Get nitraEquipmentId value
     * @return string|null
     */
    public function getNitraEquipmentId()
    {
        return $this->nitraEquipmentId;
    }
    /**
     * Set nitraEquipmentId value
     * @param string $nitraEquipmentId
     * @return \kapaks\StructType\WimaxEquipment
     */
    public function setNitraEquipmentId($nitraEquipmentId = null)
    {
        // validation for constraint: string
        if (!is_null($nitraEquipmentId) && !is_string($nitraEquipmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nitraEquipmentId)), __LINE__);
        }
        $this->nitraEquipmentId = $nitraEquipmentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\WimaxEquipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
