<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelocationRequest StructType
 * @subpackage Structs
 */
class RelocationRequest extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \kapaks\StructType\Address
     */
    public $address;
    /**
     * The callDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $callDate;
    /**
     * The connectionNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionNumber;
    /**
     * The connectionNumberType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionNumberType;
    /**
     * The referenceId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $referenceId;
    /**
     * Constructor method for RelocationRequest
     * @uses RelocationRequest::setAddress()
     * @uses RelocationRequest::setCallDate()
     * @uses RelocationRequest::setConnectionNumber()
     * @uses RelocationRequest::setConnectionNumberType()
     * @uses RelocationRequest::setReferenceId()
     * @param \kapaks\StructType\Address $address
     * @param string $callDate
     * @param string $connectionNumber
     * @param string $connectionNumberType
     * @param string $referenceId
     */
    public function __construct(\kapaks\StructType\Address $address = null, $callDate = null, $connectionNumber = null, $connectionNumberType = null, $referenceId = null)
    {
        $this
            ->setAddress($address)
            ->setCallDate($callDate)
            ->setConnectionNumber($connectionNumber)
            ->setConnectionNumberType($connectionNumberType)
            ->setReferenceId($referenceId);
    }
    /**
     * Get address value
     * @return \kapaks\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \kapaks\StructType\Address $address
     * @return \kapaks\StructType\RelocationRequest
     */
    public function setAddress(\kapaks\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get callDate value
     * @return string|null
     */
    public function getCallDate()
    {
        return $this->callDate;
    }
    /**
     * Set callDate value
     * @param string $callDate
     * @return \kapaks\StructType\RelocationRequest
     */
    public function setCallDate($callDate = null)
    {
        // validation for constraint: string
        if (!is_null($callDate) && !is_string($callDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callDate)), __LINE__);
        }
        $this->callDate = $callDate;
        return $this;
    }
    /**
     * Get connectionNumber value
     * @return string|null
     */
    public function getConnectionNumber()
    {
        return $this->connectionNumber;
    }
    /**
     * Set connectionNumber value
     * @param string $connectionNumber
     * @return \kapaks\StructType\RelocationRequest
     */
    public function setConnectionNumber($connectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($connectionNumber) && !is_string($connectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionNumber)), __LINE__);
        }
        $this->connectionNumber = $connectionNumber;
        return $this;
    }
    /**
     * Get connectionNumberType value
     * @return string|null
     */
    public function getConnectionNumberType()
    {
        return $this->connectionNumberType;
    }
    /**
     * Set connectionNumberType value
     * @param string $connectionNumberType
     * @return \kapaks\StructType\RelocationRequest
     */
    public function setConnectionNumberType($connectionNumberType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionNumberType) && !is_string($connectionNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionNumberType)), __LINE__);
        }
        $this->connectionNumberType = $connectionNumberType;
        return $this;
    }
    /**
     * Get referenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }
    /**
     * Set referenceId value
     * @param string $referenceId
     * @return \kapaks\StructType\RelocationRequest
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceId)), __LINE__);
        }
        $this->referenceId = $referenceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\RelocationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
