<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductRequest StructType
 * @subpackage Structs
 */
class ProductRequest extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \kapaks\StructType\Address
     */
    public $address;
    /**
     * The callDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $callDate;
    /**
     * The connectionNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionNumber;
    /**
     * The connectionNumberType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionNumberType;
    /**
     * The referenceId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $referenceId;
    /**
     * The requestedProduct
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $requestedProduct;
    /**
     * Constructor method for ProductRequest
     * @uses ProductRequest::setAddress()
     * @uses ProductRequest::setCallDate()
     * @uses ProductRequest::setConnectionNumber()
     * @uses ProductRequest::setConnectionNumberType()
     * @uses ProductRequest::setReferenceId()
     * @uses ProductRequest::setRequestedProduct()
     * @param \kapaks\StructType\Address $address
     * @param string $callDate
     * @param string $connectionNumber
     * @param string $connectionNumberType
     * @param string $referenceId
     * @param string $requestedProduct
     */
    public function __construct(\kapaks\StructType\Address $address = null, $callDate = null, $connectionNumber = null, $connectionNumberType = null, $referenceId = null, $requestedProduct = null)
    {
        $this
            ->setAddress($address)
            ->setCallDate($callDate)
            ->setConnectionNumber($connectionNumber)
            ->setConnectionNumberType($connectionNumberType)
            ->setReferenceId($referenceId)
            ->setRequestedProduct($requestedProduct);
    }
    /**
     * Get address value
     * @return \kapaks\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \kapaks\StructType\Address $address
     * @return \kapaks\StructType\ProductRequest
     */
    public function setAddress(\kapaks\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get callDate value
     * @return string|null
     */
    public function getCallDate()
    {
        return $this->callDate;
    }
    /**
     * Set callDate value
     * @param string $callDate
     * @return \kapaks\StructType\ProductRequest
     */
    public function setCallDate($callDate = null)
    {
        // validation for constraint: string
        if (!is_null($callDate) && !is_string($callDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callDate)), __LINE__);
        }
        $this->callDate = $callDate;
        return $this;
    }
    /**
     * Get connectionNumber value
     * @return string|null
     */
    public function getConnectionNumber()
    {
        return $this->connectionNumber;
    }
    /**
     * Set connectionNumber value
     * @param string $connectionNumber
     * @return \kapaks\StructType\ProductRequest
     */
    public function setConnectionNumber($connectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($connectionNumber) && !is_string($connectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionNumber)), __LINE__);
        }
        $this->connectionNumber = $connectionNumber;
        return $this;
    }
    /**
     * Get connectionNumberType value
     * @return string|null
     */
    public function getConnectionNumberType()
    {
        return $this->connectionNumberType;
    }
    /**
     * Set connectionNumberType value
     * @param string $connectionNumberType
     * @return \kapaks\StructType\ProductRequest
     */
    public function setConnectionNumberType($connectionNumberType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionNumberType) && !is_string($connectionNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionNumberType)), __LINE__);
        }
        $this->connectionNumberType = $connectionNumberType;
        return $this;
    }
    /**
     * Get referenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }
    /**
     * Set referenceId value
     * @param string $referenceId
     * @return \kapaks\StructType\ProductRequest
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceId)), __LINE__);
        }
        $this->referenceId = $referenceId;
        return $this;
    }
    /**
     * Get requestedProduct value
     * @return string|null
     */
    public function getRequestedProduct()
    {
        return $this->requestedProduct;
    }
    /**
     * Set requestedProduct value
     * @param string $requestedProduct
     * @return \kapaks\StructType\ProductRequest
     */
    public function setRequestedProduct($requestedProduct = null)
    {
        // validation for constraint: string
        if (!is_null($requestedProduct) && !is_string($requestedProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedProduct)), __LINE__);
        }
        $this->requestedProduct = $requestedProduct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\ProductRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
