<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinePart StructType
 * @subpackage Structs
 */
class LinePart extends AbstractStructBase
{
    /**
     * The bruksm
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bruksm;
    /**
     * The connectionPointInsideName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionPointInsideName;
    /**
     * The connectionPointInsideType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionPointInsideType;
    /**
     * The connectionPointOutsideName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionPointOutsideName;
    /**
     * The connectionPointOutsideType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $connectionPointOutsideType;
    /**
     * The linePartLength
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $linePartLength;
    /**
     * The linePartStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $linePartStatus;
    /**
     * The mks
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mks;
    /**
     * The nitraConnectionPointSign
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nitraConnectionPointSign;
    /**
     * The pupin
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $pupin;
    /**
     * The tapp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tapp;
    /**
     * The vern
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $vern;
    /**
     * The wireDiameter
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $wireDiameter;
    /**
     * The spareCapsLP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $spareCapsLP;
    /**
     * The aggregatedLengthFromCustomerAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $aggregatedLengthFromCustomerAddress;
    /**
     * The terminationEquipmentCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $terminationEquipmentCode;
    /**
     * The terminationEquipmentDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $terminationEquipmentDescription;
    /**
     * The aggregatedLengthFromCustomerAddressDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $aggregatedLengthFromCustomerAddressDescription;
    /**
     * The measuredDownstreamLimit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $measuredDownstreamLimit;
    /**
     * Constructor method for LinePart
     * @uses LinePart::setBruksm()
     * @uses LinePart::setConnectionPointInsideName()
     * @uses LinePart::setConnectionPointInsideType()
     * @uses LinePart::setConnectionPointOutsideName()
     * @uses LinePart::setConnectionPointOutsideType()
     * @uses LinePart::setLinePartLength()
     * @uses LinePart::setLinePartStatus()
     * @uses LinePart::setMks()
     * @uses LinePart::setNitraConnectionPointSign()
     * @uses LinePart::setPupin()
     * @uses LinePart::setTapp()
     * @uses LinePart::setVern()
     * @uses LinePart::setWireDiameter()
     * @uses LinePart::setSpareCapsLP()
     * @uses LinePart::setAggregatedLengthFromCustomerAddress()
     * @uses LinePart::setTerminationEquipmentCode()
     * @uses LinePart::setTerminationEquipmentDescription()
     * @uses LinePart::setAggregatedLengthFromCustomerAddressDescription()
     * @uses LinePart::setMeasuredDownstreamLimit()
     * @param string $bruksm
     * @param string $connectionPointInsideName
     * @param string $connectionPointInsideType
     * @param string $connectionPointOutsideName
     * @param string $connectionPointOutsideType
     * @param int $linePartLength
     * @param string $linePartStatus
     * @param string $mks
     * @param string $nitraConnectionPointSign
     * @param string $pupin
     * @param string $tapp
     * @param string $vern
     * @param string $wireDiameter
     * @param string[] $spareCapsLP
     * @param int $aggregatedLengthFromCustomerAddress
     * @param int $terminationEquipmentCode
     * @param string $terminationEquipmentDescription
     * @param string $aggregatedLengthFromCustomerAddressDescription
     * @param int $measuredDownstreamLimit
     */
    public function __construct($bruksm = null, $connectionPointInsideName = null, $connectionPointInsideType = null, $connectionPointOutsideName = null, $connectionPointOutsideType = null, $linePartLength = null, $linePartStatus = null, $mks = null, $nitraConnectionPointSign = null, $pupin = null, $tapp = null, $vern = null, $wireDiameter = null, array $spareCapsLP = array(), $aggregatedLengthFromCustomerAddress = null, $terminationEquipmentCode = null, $terminationEquipmentDescription = null, $aggregatedLengthFromCustomerAddressDescription = null, $measuredDownstreamLimit = null)
    {
        $this
            ->setBruksm($bruksm)
            ->setConnectionPointInsideName($connectionPointInsideName)
            ->setConnectionPointInsideType($connectionPointInsideType)
            ->setConnectionPointOutsideName($connectionPointOutsideName)
            ->setConnectionPointOutsideType($connectionPointOutsideType)
            ->setLinePartLength($linePartLength)
            ->setLinePartStatus($linePartStatus)
            ->setMks($mks)
            ->setNitraConnectionPointSign($nitraConnectionPointSign)
            ->setPupin($pupin)
            ->setTapp($tapp)
            ->setVern($vern)
            ->setWireDiameter($wireDiameter)
            ->setSpareCapsLP($spareCapsLP)
            ->setAggregatedLengthFromCustomerAddress($aggregatedLengthFromCustomerAddress)
            ->setTerminationEquipmentCode($terminationEquipmentCode)
            ->setTerminationEquipmentDescription($terminationEquipmentDescription)
            ->setAggregatedLengthFromCustomerAddressDescription($aggregatedLengthFromCustomerAddressDescription)
            ->setMeasuredDownstreamLimit($measuredDownstreamLimit);
    }
    /**
     * Get bruksm value
     * @return string|null
     */
    public function getBruksm()
    {
        return $this->bruksm;
    }
    /**
     * Set bruksm value
     * @param string $bruksm
     * @return \kapaks\StructType\LinePart
     */
    public function setBruksm($bruksm = null)
    {
        // validation for constraint: string
        if (!is_null($bruksm) && !is_string($bruksm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bruksm)), __LINE__);
        }
        $this->bruksm = $bruksm;
        return $this;
    }
    /**
     * Get connectionPointInsideName value
     * @return string|null
     */
    public function getConnectionPointInsideName()
    {
        return $this->connectionPointInsideName;
    }
    /**
     * Set connectionPointInsideName value
     * @param string $connectionPointInsideName
     * @return \kapaks\StructType\LinePart
     */
    public function setConnectionPointInsideName($connectionPointInsideName = null)
    {
        // validation for constraint: string
        if (!is_null($connectionPointInsideName) && !is_string($connectionPointInsideName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionPointInsideName)), __LINE__);
        }
        $this->connectionPointInsideName = $connectionPointInsideName;
        return $this;
    }
    /**
     * Get connectionPointInsideType value
     * @return string|null
     */
    public function getConnectionPointInsideType()
    {
        return $this->connectionPointInsideType;
    }
    /**
     * Set connectionPointInsideType value
     * @param string $connectionPointInsideType
     * @return \kapaks\StructType\LinePart
     */
    public function setConnectionPointInsideType($connectionPointInsideType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionPointInsideType) && !is_string($connectionPointInsideType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionPointInsideType)), __LINE__);
        }
        $this->connectionPointInsideType = $connectionPointInsideType;
        return $this;
    }
    /**
     * Get connectionPointOutsideName value
     * @return string|null
     */
    public function getConnectionPointOutsideName()
    {
        return $this->connectionPointOutsideName;
    }
    /**
     * Set connectionPointOutsideName value
     * @param string $connectionPointOutsideName
     * @return \kapaks\StructType\LinePart
     */
    public function setConnectionPointOutsideName($connectionPointOutsideName = null)
    {
        // validation for constraint: string
        if (!is_null($connectionPointOutsideName) && !is_string($connectionPointOutsideName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionPointOutsideName)), __LINE__);
        }
        $this->connectionPointOutsideName = $connectionPointOutsideName;
        return $this;
    }
    /**
     * Get connectionPointOutsideType value
     * @return string|null
     */
    public function getConnectionPointOutsideType()
    {
        return $this->connectionPointOutsideType;
    }
    /**
     * Set connectionPointOutsideType value
     * @param string $connectionPointOutsideType
     * @return \kapaks\StructType\LinePart
     */
    public function setConnectionPointOutsideType($connectionPointOutsideType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionPointOutsideType) && !is_string($connectionPointOutsideType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionPointOutsideType)), __LINE__);
        }
        $this->connectionPointOutsideType = $connectionPointOutsideType;
        return $this;
    }
    /**
     * Get linePartLength value
     * @return int|null
     */
    public function getLinePartLength()
    {
        return $this->linePartLength;
    }
    /**
     * Set linePartLength value
     * @param int $linePartLength
     * @return \kapaks\StructType\LinePart
     */
    public function setLinePartLength($linePartLength = null)
    {
        // validation for constraint: int
        if (!is_null($linePartLength) && !is_numeric($linePartLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($linePartLength)), __LINE__);
        }
        $this->linePartLength = $linePartLength;
        return $this;
    }
    /**
     * Get linePartStatus value
     * @return string|null
     */
    public function getLinePartStatus()
    {
        return $this->linePartStatus;
    }
    /**
     * Set linePartStatus value
     * @param string $linePartStatus
     * @return \kapaks\StructType\LinePart
     */
    public function setLinePartStatus($linePartStatus = null)
    {
        // validation for constraint: string
        if (!is_null($linePartStatus) && !is_string($linePartStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linePartStatus)), __LINE__);
        }
        $this->linePartStatus = $linePartStatus;
        return $this;
    }
    /**
     * Get mks value
     * @return string|null
     */
    public function getMks()
    {
        return $this->mks;
    }
    /**
     * Set mks value
     * @param string $mks
     * @return \kapaks\StructType\LinePart
     */
    public function setMks($mks = null)
    {
        // validation for constraint: string
        if (!is_null($mks) && !is_string($mks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mks)), __LINE__);
        }
        $this->mks = $mks;
        return $this;
    }
    /**
     * Get nitraConnectionPointSign value
     * @return string|null
     */
    public function getNitraConnectionPointSign()
    {
        return $this->nitraConnectionPointSign;
    }
    /**
     * Set nitraConnectionPointSign value
     * @param string $nitraConnectionPointSign
     * @return \kapaks\StructType\LinePart
     */
    public function setNitraConnectionPointSign($nitraConnectionPointSign = null)
    {
        // validation for constraint: string
        if (!is_null($nitraConnectionPointSign) && !is_string($nitraConnectionPointSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nitraConnectionPointSign)), __LINE__);
        }
        $this->nitraConnectionPointSign = $nitraConnectionPointSign;
        return $this;
    }
    /**
     * Get pupin value
     * @return string|null
     */
    public function getPupin()
    {
        return $this->pupin;
    }
    /**
     * Set pupin value
     * @param string $pupin
     * @return \kapaks\StructType\LinePart
     */
    public function setPupin($pupin = null)
    {
        // validation for constraint: string
        if (!is_null($pupin) && !is_string($pupin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pupin)), __LINE__);
        }
        $this->pupin = $pupin;
        return $this;
    }
    /**
     * Get tapp value
     * @return string|null
     */
    public function getTapp()
    {
        return $this->tapp;
    }
    /**
     * Set tapp value
     * @param string $tapp
     * @return \kapaks\StructType\LinePart
     */
    public function setTapp($tapp = null)
    {
        // validation for constraint: string
        if (!is_null($tapp) && !is_string($tapp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tapp)), __LINE__);
        }
        $this->tapp = $tapp;
        return $this;
    }
    /**
     * Get vern value
     * @return string|null
     */
    public function getVern()
    {
        return $this->vern;
    }
    /**
     * Set vern value
     * @param string $vern
     * @return \kapaks\StructType\LinePart
     */
    public function setVern($vern = null)
    {
        // validation for constraint: string
        if (!is_null($vern) && !is_string($vern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vern)), __LINE__);
        }
        $this->vern = $vern;
        return $this;
    }
    /**
     * Get wireDiameter value
     * @return string|null
     */
    public function getWireDiameter()
    {
        return $this->wireDiameter;
    }
    /**
     * Set wireDiameter value
     * @param string $wireDiameter
     * @return \kapaks\StructType\LinePart
     */
    public function setWireDiameter($wireDiameter = null)
    {
        // validation for constraint: string
        if (!is_null($wireDiameter) && !is_string($wireDiameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wireDiameter)), __LINE__);
        }
        $this->wireDiameter = $wireDiameter;
        return $this;
    }
    /**
     * Get spareCapsLP value
     * @return string[]|null
     */
    public function getSpareCapsLP()
    {
        return $this->spareCapsLP;
    }
    /**
     * Set spareCapsLP value
     * @throws \InvalidArgumentException
     * @param string[] $spareCapsLP
     * @return \kapaks\StructType\LinePart
     */
    public function setSpareCapsLP(array $spareCapsLP = array())
    {
        foreach ($spareCapsLP as $linePartSpareCapsLPItem) {
            // validation for constraint: itemType
            if (!is_string($linePartSpareCapsLPItem)) {
                throw new \InvalidArgumentException(sprintf('The spareCapsLP property can only contain items of string, "%s" given', is_object($linePartSpareCapsLPItem) ? get_class($linePartSpareCapsLPItem) : gettype($linePartSpareCapsLPItem)), __LINE__);
            }
        }
        $this->spareCapsLP = $spareCapsLP;
        return $this;
    }
    /**
     * Add item to spareCapsLP value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\LinePart
     */
    public function addToSpareCapsLP($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The spareCapsLP property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->spareCapsLP[] = $item;
        return $this;
    }
    /**
     * Get aggregatedLengthFromCustomerAddress value
     * @return int|null
     */
    public function getAggregatedLengthFromCustomerAddress()
    {
        return $this->aggregatedLengthFromCustomerAddress;
    }
    /**
     * Set aggregatedLengthFromCustomerAddress value
     * @param int $aggregatedLengthFromCustomerAddress
     * @return \kapaks\StructType\LinePart
     */
    public function setAggregatedLengthFromCustomerAddress($aggregatedLengthFromCustomerAddress = null)
    {
        // validation for constraint: int
        if (!is_null($aggregatedLengthFromCustomerAddress) && !is_numeric($aggregatedLengthFromCustomerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aggregatedLengthFromCustomerAddress)), __LINE__);
        }
        $this->aggregatedLengthFromCustomerAddress = $aggregatedLengthFromCustomerAddress;
        return $this;
    }
    /**
     * Get terminationEquipmentCode value
     * @return int|null
     */
    public function getTerminationEquipmentCode()
    {
        return $this->terminationEquipmentCode;
    }
    /**
     * Set terminationEquipmentCode value
     * @param int $terminationEquipmentCode
     * @return \kapaks\StructType\LinePart
     */
    public function setTerminationEquipmentCode($terminationEquipmentCode = null)
    {
        // validation for constraint: int
        if (!is_null($terminationEquipmentCode) && !is_numeric($terminationEquipmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($terminationEquipmentCode)), __LINE__);
        }
        $this->terminationEquipmentCode = $terminationEquipmentCode;
        return $this;
    }
    /**
     * Get terminationEquipmentDescription value
     * @return string|null
     */
    public function getTerminationEquipmentDescription()
    {
        return $this->terminationEquipmentDescription;
    }
    /**
     * Set terminationEquipmentDescription value
     * @param string $terminationEquipmentDescription
     * @return \kapaks\StructType\LinePart
     */
    public function setTerminationEquipmentDescription($terminationEquipmentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($terminationEquipmentDescription) && !is_string($terminationEquipmentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminationEquipmentDescription)), __LINE__);
        }
        $this->terminationEquipmentDescription = $terminationEquipmentDescription;
        return $this;
    }
    /**
     * Get aggregatedLengthFromCustomerAddressDescription value
     * @return string|null
     */
    public function getAggregatedLengthFromCustomerAddressDescription()
    {
        return $this->aggregatedLengthFromCustomerAddressDescription;
    }
    /**
     * Set aggregatedLengthFromCustomerAddressDescription value
     * @param string $aggregatedLengthFromCustomerAddressDescription
     * @return \kapaks\StructType\LinePart
     */
    public function setAggregatedLengthFromCustomerAddressDescription($aggregatedLengthFromCustomerAddressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($aggregatedLengthFromCustomerAddressDescription) && !is_string($aggregatedLengthFromCustomerAddressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aggregatedLengthFromCustomerAddressDescription)), __LINE__);
        }
        $this->aggregatedLengthFromCustomerAddressDescription = $aggregatedLengthFromCustomerAddressDescription;
        return $this;
    }
    /**
     * Get measuredDownstreamLimit value
     * @return int|null
     */
    public function getMeasuredDownstreamLimit()
    {
        return $this->measuredDownstreamLimit;
    }
    /**
     * Set measuredDownstreamLimit value
     * @param int $measuredDownstreamLimit
     * @return \kapaks\StructType\LinePart
     */
    public function setMeasuredDownstreamLimit($measuredDownstreamLimit = null)
    {
        // validation for constraint: int
        if (!is_null($measuredDownstreamLimit) && !is_numeric($measuredDownstreamLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($measuredDownstreamLimit)), __LINE__);
        }
        $this->measuredDownstreamLimit = $measuredDownstreamLimit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\LinePart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
