<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Equipment StructType
 * @subpackage Structs
 */
class Equipment extends AbstractStructBase
{
    /**
     * The equipmentRemark
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $equipmentRemark;
    /**
     * The manufacturer
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $manufacturer;
    /**
     * The nitraEquipmentSign
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nitraEquipmentSign;
    /**
     * The numberOfAvailablePorts
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $numberOfAvailablePorts;
    /**
     * The numberOfPorts
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $numberOfPorts;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $owner;
    /**
     * The portNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $portNumber;
    /**
     * The portType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $portType;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \kapaks\StructType\Address
     */
    public $address;
    /**
     * The broadbandPortType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $broadbandPortType;
    /**
     * The spareCapsEQ
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $spareCapsEQ;
    /**
     * The dslamInterfaceFlags
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dslamInterfaceFlags;
    /**
     * The dslamInterfaceFlagsDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dslamInterfaceFlagsDescription;
    /**
     * The broadbandNodeId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $broadbandNodeId;
    /**
     * The broadbandPortNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $broadbandPortNumber;
    /**
     * The cpeId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cpeId;
    /**
     * The equipmentBestServiceClass
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $equipmentBestServiceClass;
    /**
     * The equipmentType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $equipmentType;
    /**
     * Constructor method for Equipment
     * @uses Equipment::setEquipmentRemark()
     * @uses Equipment::setManufacturer()
     * @uses Equipment::setNitraEquipmentSign()
     * @uses Equipment::setNumberOfAvailablePorts()
     * @uses Equipment::setNumberOfPorts()
     * @uses Equipment::setOwner()
     * @uses Equipment::setPortNumber()
     * @uses Equipment::setPortType()
     * @uses Equipment::setAddress()
     * @uses Equipment::setBroadbandPortType()
     * @uses Equipment::setSpareCapsEQ()
     * @uses Equipment::setDslamInterfaceFlags()
     * @uses Equipment::setDslamInterfaceFlagsDescription()
     * @uses Equipment::setBroadbandNodeId()
     * @uses Equipment::setBroadbandPortNumber()
     * @uses Equipment::setCpeId()
     * @uses Equipment::setEquipmentBestServiceClass()
     * @uses Equipment::setEquipmentType()
     * @param string $equipmentRemark
     * @param string $manufacturer
     * @param string $nitraEquipmentSign
     * @param int $numberOfAvailablePorts
     * @param int $numberOfPorts
     * @param string $owner
     * @param string $portNumber
     * @param string $portType
     * @param \kapaks\StructType\Address $address
     * @param string $broadbandPortType
     * @param string[] $spareCapsEQ
     * @param string $dslamInterfaceFlags
     * @param string $dslamInterfaceFlagsDescription
     * @param string $broadbandNodeId
     * @param string $broadbandPortNumber
     * @param string $cpeId
     * @param string $equipmentBestServiceClass
     * @param string $equipmentType
     */
    public function __construct($equipmentRemark = null, $manufacturer = null, $nitraEquipmentSign = null, $numberOfAvailablePorts = null, $numberOfPorts = null, $owner = null, $portNumber = null, $portType = null, \kapaks\StructType\Address $address = null, $broadbandPortType = null, array $spareCapsEQ = array(), $dslamInterfaceFlags = null, $dslamInterfaceFlagsDescription = null, $broadbandNodeId = null, $broadbandPortNumber = null, $cpeId = null, $equipmentBestServiceClass = null, $equipmentType = null)
    {
        $this
            ->setEquipmentRemark($equipmentRemark)
            ->setManufacturer($manufacturer)
            ->setNitraEquipmentSign($nitraEquipmentSign)
            ->setNumberOfAvailablePorts($numberOfAvailablePorts)
            ->setNumberOfPorts($numberOfPorts)
            ->setOwner($owner)
            ->setPortNumber($portNumber)
            ->setPortType($portType)
            ->setAddress($address)
            ->setBroadbandPortType($broadbandPortType)
            ->setSpareCapsEQ($spareCapsEQ)
            ->setDslamInterfaceFlags($dslamInterfaceFlags)
            ->setDslamInterfaceFlagsDescription($dslamInterfaceFlagsDescription)
            ->setBroadbandNodeId($broadbandNodeId)
            ->setBroadbandPortNumber($broadbandPortNumber)
            ->setCpeId($cpeId)
            ->setEquipmentBestServiceClass($equipmentBestServiceClass)
            ->setEquipmentType($equipmentType);
    }
    /**
     * Get equipmentRemark value
     * @return string|null
     */
    public function getEquipmentRemark()
    {
        return $this->equipmentRemark;
    }
    /**
     * Set equipmentRemark value
     * @param string $equipmentRemark
     * @return \kapaks\StructType\Equipment
     */
    public function setEquipmentRemark($equipmentRemark = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentRemark) && !is_string($equipmentRemark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentRemark)), __LINE__);
        }
        $this->equipmentRemark = $equipmentRemark;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \kapaks\StructType\Equipment
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get nitraEquipmentSign value
     * @return string|null
     */
    public function getNitraEquipmentSign()
    {
        return $this->nitraEquipmentSign;
    }
    /**
     * Set nitraEquipmentSign value
     * @param string $nitraEquipmentSign
     * @return \kapaks\StructType\Equipment
     */
    public function setNitraEquipmentSign($nitraEquipmentSign = null)
    {
        // validation for constraint: string
        if (!is_null($nitraEquipmentSign) && !is_string($nitraEquipmentSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nitraEquipmentSign)), __LINE__);
        }
        $this->nitraEquipmentSign = $nitraEquipmentSign;
        return $this;
    }
    /**
     * Get numberOfAvailablePorts value
     * @return int|null
     */
    public function getNumberOfAvailablePorts()
    {
        return $this->numberOfAvailablePorts;
    }
    /**
     * Set numberOfAvailablePorts value
     * @param int $numberOfAvailablePorts
     * @return \kapaks\StructType\Equipment
     */
    public function setNumberOfAvailablePorts($numberOfAvailablePorts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAvailablePorts) && !is_numeric($numberOfAvailablePorts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfAvailablePorts)), __LINE__);
        }
        $this->numberOfAvailablePorts = $numberOfAvailablePorts;
        return $this;
    }
    /**
     * Get numberOfPorts value
     * @return int|null
     */
    public function getNumberOfPorts()
    {
        return $this->numberOfPorts;
    }
    /**
     * Set numberOfPorts value
     * @param int $numberOfPorts
     * @return \kapaks\StructType\Equipment
     */
    public function setNumberOfPorts($numberOfPorts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPorts) && !is_numeric($numberOfPorts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPorts)), __LINE__);
        }
        $this->numberOfPorts = $numberOfPorts;
        return $this;
    }
    /**
     * Get owner value
     * @return string|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param string $owner
     * @return \kapaks\StructType\Equipment
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner)), __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get portNumber value
     * @return string|null
     */
    public function getPortNumber()
    {
        return $this->portNumber;
    }
    /**
     * Set portNumber value
     * @param string $portNumber
     * @return \kapaks\StructType\Equipment
     */
    public function setPortNumber($portNumber = null)
    {
        // validation for constraint: string
        if (!is_null($portNumber) && !is_string($portNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portNumber)), __LINE__);
        }
        $this->portNumber = $portNumber;
        return $this;
    }
    /**
     * Get portType value
     * @return string|null
     */
    public function getPortType()
    {
        return $this->portType;
    }
    /**
     * Set portType value
     * @param string $portType
     * @return \kapaks\StructType\Equipment
     */
    public function setPortType($portType = null)
    {
        // validation for constraint: string
        if (!is_null($portType) && !is_string($portType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portType)), __LINE__);
        }
        $this->portType = $portType;
        return $this;
    }
    /**
     * Get address value
     * @return \kapaks\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \kapaks\StructType\Address $address
     * @return \kapaks\StructType\Equipment
     */
    public function setAddress(\kapaks\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get broadbandPortType value
     * @return string|null
     */
    public function getBroadbandPortType()
    {
        return $this->broadbandPortType;
    }
    /**
     * Set broadbandPortType value
     * @param string $broadbandPortType
     * @return \kapaks\StructType\Equipment
     */
    public function setBroadbandPortType($broadbandPortType = null)
    {
        // validation for constraint: string
        if (!is_null($broadbandPortType) && !is_string($broadbandPortType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($broadbandPortType)), __LINE__);
        }
        $this->broadbandPortType = $broadbandPortType;
        return $this;
    }
    /**
     * Get spareCapsEQ value
     * @return string[]|null
     */
    public function getSpareCapsEQ()
    {
        return $this->spareCapsEQ;
    }
    /**
     * Set spareCapsEQ value
     * @throws \InvalidArgumentException
     * @param string[] $spareCapsEQ
     * @return \kapaks\StructType\Equipment
     */
    public function setSpareCapsEQ(array $spareCapsEQ = array())
    {
        foreach ($spareCapsEQ as $equipmentSpareCapsEQItem) {
            // validation for constraint: itemType
            if (!is_string($equipmentSpareCapsEQItem)) {
                throw new \InvalidArgumentException(sprintf('The spareCapsEQ property can only contain items of string, "%s" given', is_object($equipmentSpareCapsEQItem) ? get_class($equipmentSpareCapsEQItem) : gettype($equipmentSpareCapsEQItem)), __LINE__);
            }
        }
        $this->spareCapsEQ = $spareCapsEQ;
        return $this;
    }
    /**
     * Add item to spareCapsEQ value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\Equipment
     */
    public function addToSpareCapsEQ($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The spareCapsEQ property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->spareCapsEQ[] = $item;
        return $this;
    }
    /**
     * Get dslamInterfaceFlags value
     * @return string|null
     */
    public function getDslamInterfaceFlags()
    {
        return $this->dslamInterfaceFlags;
    }
    /**
     * Set dslamInterfaceFlags value
     * @param string $dslamInterfaceFlags
     * @return \kapaks\StructType\Equipment
     */
    public function setDslamInterfaceFlags($dslamInterfaceFlags = null)
    {
        // validation for constraint: string
        if (!is_null($dslamInterfaceFlags) && !is_string($dslamInterfaceFlags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dslamInterfaceFlags)), __LINE__);
        }
        $this->dslamInterfaceFlags = $dslamInterfaceFlags;
        return $this;
    }
    /**
     * Get dslamInterfaceFlagsDescription value
     * @return string|null
     */
    public function getDslamInterfaceFlagsDescription()
    {
        return $this->dslamInterfaceFlagsDescription;
    }
    /**
     * Set dslamInterfaceFlagsDescription value
     * @param string $dslamInterfaceFlagsDescription
     * @return \kapaks\StructType\Equipment
     */
    public function setDslamInterfaceFlagsDescription($dslamInterfaceFlagsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($dslamInterfaceFlagsDescription) && !is_string($dslamInterfaceFlagsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dslamInterfaceFlagsDescription)), __LINE__);
        }
        $this->dslamInterfaceFlagsDescription = $dslamInterfaceFlagsDescription;
        return $this;
    }
    /**
     * Get broadbandNodeId value
     * @return string|null
     */
    public function getBroadbandNodeId()
    {
        return $this->broadbandNodeId;
    }
    /**
     * Set broadbandNodeId value
     * @param string $broadbandNodeId
     * @return \kapaks\StructType\Equipment
     */
    public function setBroadbandNodeId($broadbandNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($broadbandNodeId) && !is_string($broadbandNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($broadbandNodeId)), __LINE__);
        }
        $this->broadbandNodeId = $broadbandNodeId;
        return $this;
    }
    /**
     * Get broadbandPortNumber value
     * @return string|null
     */
    public function getBroadbandPortNumber()
    {
        return $this->broadbandPortNumber;
    }
    /**
     * Set broadbandPortNumber value
     * @param string $broadbandPortNumber
     * @return \kapaks\StructType\Equipment
     */
    public function setBroadbandPortNumber($broadbandPortNumber = null)
    {
        // validation for constraint: string
        if (!is_null($broadbandPortNumber) && !is_string($broadbandPortNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($broadbandPortNumber)), __LINE__);
        }
        $this->broadbandPortNumber = $broadbandPortNumber;
        return $this;
    }
    /**
     * Get cpeId value
     * @return string|null
     */
    public function getCpeId()
    {
        return $this->cpeId;
    }
    /**
     * Set cpeId value
     * @param string $cpeId
     * @return \kapaks\StructType\Equipment
     */
    public function setCpeId($cpeId = null)
    {
        // validation for constraint: string
        if (!is_null($cpeId) && !is_string($cpeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cpeId)), __LINE__);
        }
        $this->cpeId = $cpeId;
        return $this;
    }
    /**
     * Get equipmentBestServiceClass value
     * @return string|null
     */
    public function getEquipmentBestServiceClass()
    {
        return $this->equipmentBestServiceClass;
    }
    /**
     * Set equipmentBestServiceClass value
     * @param string $equipmentBestServiceClass
     * @return \kapaks\StructType\Equipment
     */
    public function setEquipmentBestServiceClass($equipmentBestServiceClass = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentBestServiceClass) && !is_string($equipmentBestServiceClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentBestServiceClass)), __LINE__);
        }
        $this->equipmentBestServiceClass = $equipmentBestServiceClass;
        return $this;
    }
    /**
     * Get equipmentType value
     * @return string|null
     */
    public function getEquipmentType()
    {
        return $this->equipmentType;
    }
    /**
     * Set equipmentType value
     * @param string $equipmentType
     * @return \kapaks\StructType\Equipment
     */
    public function setEquipmentType($equipmentType = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentType) && !is_string($equipmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentType)), __LINE__);
        }
        $this->equipmentType = $equipmentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\Equipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
