<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The apartmentNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $apartmentNumber;
    /**
     * The county
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $county;
    /**
     * The farId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $farId;
    /**
     * The floor
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $floor;
    /**
     * The houseLetter
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $houseLetter;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $houseNumber;
    /**
     * The municipalityName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $municipalityName;
    /**
     * The municipalityNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $municipalityNumber;
    /**
     * The postalCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $postalCode;
    /**
     * The postalPlace
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $postalPlace;
    /**
     * The propertyNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $propertyNumber;
    /**
     * The propertyPartNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $propertyPartNumber;
    /**
     * The streetCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $streetCode;
    /**
     * The streetCodeType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $streetCodeType;
    /**
     * The streetName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $streetName;
    /**
     * Constructor method for Address
     * @uses Address::setApartmentNumber()
     * @uses Address::setCounty()
     * @uses Address::setFarId()
     * @uses Address::setFloor()
     * @uses Address::setHouseLetter()
     * @uses Address::setHouseNumber()
     * @uses Address::setMunicipalityName()
     * @uses Address::setMunicipalityNumber()
     * @uses Address::setPostalCode()
     * @uses Address::setPostalPlace()
     * @uses Address::setPropertyNumber()
     * @uses Address::setPropertyPartNumber()
     * @uses Address::setStreetCode()
     * @uses Address::setStreetCodeType()
     * @uses Address::setStreetName()
     * @param string $apartmentNumber
     * @param string $county
     * @param int $farId
     * @param string $floor
     * @param string $houseLetter
     * @param int $houseNumber
     * @param string $municipalityName
     * @param string $municipalityNumber
     * @param string $postalCode
     * @param string $postalPlace
     * @param string $propertyNumber
     * @param int $propertyPartNumber
     * @param string $streetCode
     * @param string $streetCodeType
     * @param string $streetName
     */
    public function __construct($apartmentNumber = null, $county = null, $farId = null, $floor = null, $houseLetter = null, $houseNumber = null, $municipalityName = null, $municipalityNumber = null, $postalCode = null, $postalPlace = null, $propertyNumber = null, $propertyPartNumber = null, $streetCode = null, $streetCodeType = null, $streetName = null)
    {
        $this
            ->setApartmentNumber($apartmentNumber)
            ->setCounty($county)
            ->setFarId($farId)
            ->setFloor($floor)
            ->setHouseLetter($houseLetter)
            ->setHouseNumber($houseNumber)
            ->setMunicipalityName($municipalityName)
            ->setMunicipalityNumber($municipalityNumber)
            ->setPostalCode($postalCode)
            ->setPostalPlace($postalPlace)
            ->setPropertyNumber($propertyNumber)
            ->setPropertyPartNumber($propertyPartNumber)
            ->setStreetCode($streetCode)
            ->setStreetCodeType($streetCodeType)
            ->setStreetName($streetName);
    }
    /**
     * Get apartmentNumber value
     * @return string|null
     */
    public function getApartmentNumber()
    {
        return $this->apartmentNumber;
    }
    /**
     * Set apartmentNumber value
     * @param string $apartmentNumber
     * @return \kapaks\StructType\Address
     */
    public function setApartmentNumber($apartmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($apartmentNumber) && !is_string($apartmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apartmentNumber)), __LINE__);
        }
        $this->apartmentNumber = $apartmentNumber;
        return $this;
    }
    /**
     * Get county value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->county;
    }
    /**
     * Set county value
     * @param string $county
     * @return \kapaks\StructType\Address
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($county)), __LINE__);
        }
        $this->county = $county;
        return $this;
    }
    /**
     * Get farId value
     * @return int|null
     */
    public function getFarId()
    {
        return $this->farId;
    }
    /**
     * Set farId value
     * @param int $farId
     * @return \kapaks\StructType\Address
     */
    public function setFarId($farId = null)
    {
        // validation for constraint: int
        if (!is_null($farId) && !is_numeric($farId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($farId)), __LINE__);
        }
        $this->farId = $farId;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \kapaks\StructType\Address
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get houseLetter value
     * @return string|null
     */
    public function getHouseLetter()
    {
        return $this->houseLetter;
    }
    /**
     * Set houseLetter value
     * @param string $houseLetter
     * @return \kapaks\StructType\Address
     */
    public function setHouseLetter($houseLetter = null)
    {
        // validation for constraint: string
        if (!is_null($houseLetter) && !is_string($houseLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseLetter)), __LINE__);
        }
        $this->houseLetter = $houseLetter;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return int|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param int $houseNumber
     * @return \kapaks\StructType\Address
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($houseNumber) && !is_numeric($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get municipalityName value
     * @return string|null
     */
    public function getMunicipalityName()
    {
        return $this->municipalityName;
    }
    /**
     * Set municipalityName value
     * @param string $municipalityName
     * @return \kapaks\StructType\Address
     */
    public function setMunicipalityName($municipalityName = null)
    {
        // validation for constraint: string
        if (!is_null($municipalityName) && !is_string($municipalityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipalityName)), __LINE__);
        }
        $this->municipalityName = $municipalityName;
        return $this;
    }
    /**
     * Get municipalityNumber value
     * @return string|null
     */
    public function getMunicipalityNumber()
    {
        return $this->municipalityNumber;
    }
    /**
     * Set municipalityNumber value
     * @param string $municipalityNumber
     * @return \kapaks\StructType\Address
     */
    public function setMunicipalityNumber($municipalityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($municipalityNumber) && !is_string($municipalityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipalityNumber)), __LINE__);
        }
        $this->municipalityNumber = $municipalityNumber;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \kapaks\StructType\Address
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get postalPlace value
     * @return string|null
     */
    public function getPostalPlace()
    {
        return $this->postalPlace;
    }
    /**
     * Set postalPlace value
     * @param string $postalPlace
     * @return \kapaks\StructType\Address
     */
    public function setPostalPlace($postalPlace = null)
    {
        // validation for constraint: string
        if (!is_null($postalPlace) && !is_string($postalPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalPlace)), __LINE__);
        }
        $this->postalPlace = $postalPlace;
        return $this;
    }
    /**
     * Get propertyNumber value
     * @return string|null
     */
    public function getPropertyNumber()
    {
        return $this->propertyNumber;
    }
    /**
     * Set propertyNumber value
     * @param string $propertyNumber
     * @return \kapaks\StructType\Address
     */
    public function setPropertyNumber($propertyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($propertyNumber) && !is_string($propertyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyNumber)), __LINE__);
        }
        $this->propertyNumber = $propertyNumber;
        return $this;
    }
    /**
     * Get propertyPartNumber value
     * @return int|null
     */
    public function getPropertyPartNumber()
    {
        return $this->propertyPartNumber;
    }
    /**
     * Set propertyPartNumber value
     * @param int $propertyPartNumber
     * @return \kapaks\StructType\Address
     */
    public function setPropertyPartNumber($propertyPartNumber = null)
    {
        // validation for constraint: int
        if (!is_null($propertyPartNumber) && !is_numeric($propertyPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($propertyPartNumber)), __LINE__);
        }
        $this->propertyPartNumber = $propertyPartNumber;
        return $this;
    }
    /**
     * Get streetCode value
     * @return string|null
     */
    public function getStreetCode()
    {
        return $this->streetCode;
    }
    /**
     * Set streetCode value
     * @param string $streetCode
     * @return \kapaks\StructType\Address
     */
    public function setStreetCode($streetCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetCode) && !is_string($streetCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetCode)), __LINE__);
        }
        $this->streetCode = $streetCode;
        return $this;
    }
    /**
     * Get streetCodeType value
     * @return string|null
     */
    public function getStreetCodeType()
    {
        return $this->streetCodeType;
    }
    /**
     * Set streetCodeType value
     * @param string $streetCodeType
     * @return \kapaks\StructType\Address
     */
    public function setStreetCodeType($streetCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($streetCodeType) && !is_string($streetCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetCodeType)), __LINE__);
        }
        $this->streetCodeType = $streetCodeType;
        return $this;
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \kapaks\StructType\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
