<?php

namespace kapaks\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALCProductResponse StructType
 * @subpackage Structs
 */
class ALCProductResponse extends AbstractStructBase
{
    /**
     * The remarksProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $remarksProperties;
    /**
     * The allAvailableServiceClassText
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $allAvailableServiceClassText;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \kapaks\StructType\Address
     */
    public $address;
    /**
     * The answerText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $answerText;
    /**
     * The answerCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $answerCode;
    /**
     * The bestBitrateDown
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $bestBitrateDown;
    /**
     * The bestBitrateUp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $bestBitrateUp;
    /**
     * The bestServiceClassCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bestServiceClassCode;
    /**
     * The bestServiceClassText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bestServiceClassText;
    /**
     * The bkat
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bkat;
    /**
     * The broadbandLineStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $broadbandLineStatus;
    /**
     * The broadbandNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $broadbandNumber;
    /**
     * The callDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $callDate;
    /**
     * The dropLength
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $dropLength;
    /**
     * The dropLengthType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dropLengthType;
    /**
     * The equipmentDeliveryDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $equipmentDeliveryDate;
    /**
     * The kapaksId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $kapaksId;
    /**
     * The lineDeliveryDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineDeliveryDate;
    /**
     * The lineNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineNumber;
    /**
     * The linePart
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var \kapaks\StructType\LinePart[]
     */
    public $linePart;
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $part;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reason;
    /**
     * The referenceId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $referenceId;
    /**
     * The remarksCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var int[]
     */
    public $remarksCode;
    /**
     * The remarksText
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $remarksText;
    /**
     * The reqConnectionNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reqConnectionNumber;
    /**
     * The reqConnectionNumberType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reqConnectionNumberType;
    /**
     * The requestedProduct
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $requestedProduct;
    /**
     * The responseDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $responseDate;
    /**
     * The resultCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $resultCode;
    /**
     * The resultText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $resultText;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $serviceType;
    /**
     * The statusCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $statusCode;
    /**
     * The statusComment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $statusComment;
    /**
     * The statusText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $statusText;
    /**
     * The telephoneLineStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telephoneLineStatus;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telephoneNumber;
    /**
     * The telsisFSL
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telsisFSL;
    /**
     * The telsisGSL
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telsisGSL;
    /**
     * The telsisMotherSign
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telsisMotherSign;
    /**
     * The totalLength
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $totalLength;
    /**
     * The prodInstBitrateDown
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $prodInstBitrateDown;
    /**
     * The prodInstBitrateUp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $prodInstBitrateUp;
    /**
     * The productInstalled
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $productInstalled;
    /**
     * The subscriberName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $subscriberName;
    /**
     * The equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var \kapaks\StructType\Equipment[]
     */
    public $equipment;
    /**
     * The spareCapsPR
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $spareCapsPR;
    /**
     * The equipmentForTVDeliveryDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $equipmentForTVDeliveryDate;
    /**
     * The allAvailableServiceClassCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var int[]
     */
    public $allAvailableServiceClassCode;
    /**
     * The multicastSupport
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $multicastSupport;
    /**
     * The measuredResultInfo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $measuredResultInfo;
    /**
     * The numberOfFreeLines
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $numberOfFreeLines;
    /**
     * The wimaxEquipment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \kapaks\StructType\WimaxEquipment
     */
    public $wimaxEquipment;
    /**
     * The physicalLineId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $physicalLineId;
    /**
     * The privateNetworkInformationText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $privateNetworkInformationText;
    /**
     * The privateNetworkOwner
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $privateNetworkOwner;
    /**
     * The privateNetworkType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $privateNetworkType;
    /**
     * The bruttoDownLinkSpeed
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bruttoDownLinkSpeed;
    /**
     * The bruttoUpLinkSpeed
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bruttoUpLinkSpeed;
    /**
     * The nettoDownLinkSpeed
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nettoDownLinkSpeed;
    /**
     * The nettoUpLinkSpeed
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nettoUpLinkSpeed;
    /**
     * Constructor method for ALCProductResponse
     * @uses ALCProductResponse::setRemarksProperties()
     * @uses ALCProductResponse::setAllAvailableServiceClassText()
     * @uses ALCProductResponse::setAddress()
     * @uses ALCProductResponse::setAnswerText()
     * @uses ALCProductResponse::setAnswerCode()
     * @uses ALCProductResponse::setBestBitrateDown()
     * @uses ALCProductResponse::setBestBitrateUp()
     * @uses ALCProductResponse::setBestServiceClassCode()
     * @uses ALCProductResponse::setBestServiceClassText()
     * @uses ALCProductResponse::setBkat()
     * @uses ALCProductResponse::setBroadbandLineStatus()
     * @uses ALCProductResponse::setBroadbandNumber()
     * @uses ALCProductResponse::setCallDate()
     * @uses ALCProductResponse::setDropLength()
     * @uses ALCProductResponse::setDropLengthType()
     * @uses ALCProductResponse::setEquipmentDeliveryDate()
     * @uses ALCProductResponse::setKapaksId()
     * @uses ALCProductResponse::setLineDeliveryDate()
     * @uses ALCProductResponse::setLineNumber()
     * @uses ALCProductResponse::setLinePart()
     * @uses ALCProductResponse::setPart()
     * @uses ALCProductResponse::setReason()
     * @uses ALCProductResponse::setReferenceId()
     * @uses ALCProductResponse::setRemarksCode()
     * @uses ALCProductResponse::setRemarksText()
     * @uses ALCProductResponse::setReqConnectionNumber()
     * @uses ALCProductResponse::setReqConnectionNumberType()
     * @uses ALCProductResponse::setRequestedProduct()
     * @uses ALCProductResponse::setResponseDate()
     * @uses ALCProductResponse::setResultCode()
     * @uses ALCProductResponse::setResultText()
     * @uses ALCProductResponse::setServiceType()
     * @uses ALCProductResponse::setStatusCode()
     * @uses ALCProductResponse::setStatusComment()
     * @uses ALCProductResponse::setStatusText()
     * @uses ALCProductResponse::setTelephoneLineStatus()
     * @uses ALCProductResponse::setTelephoneNumber()
     * @uses ALCProductResponse::setTelsisFSL()
     * @uses ALCProductResponse::setTelsisGSL()
     * @uses ALCProductResponse::setTelsisMotherSign()
     * @uses ALCProductResponse::setTotalLength()
     * @uses ALCProductResponse::setProdInstBitrateDown()
     * @uses ALCProductResponse::setProdInstBitrateUp()
     * @uses ALCProductResponse::setProductInstalled()
     * @uses ALCProductResponse::setSubscriberName()
     * @uses ALCProductResponse::setEquipment()
     * @uses ALCProductResponse::setSpareCapsPR()
     * @uses ALCProductResponse::setEquipmentForTVDeliveryDate()
     * @uses ALCProductResponse::setAllAvailableServiceClassCode()
     * @uses ALCProductResponse::setMulticastSupport()
     * @uses ALCProductResponse::setMeasuredResultInfo()
     * @uses ALCProductResponse::setNumberOfFreeLines()
     * @uses ALCProductResponse::setWimaxEquipment()
     * @uses ALCProductResponse::setPhysicalLineId()
     * @uses ALCProductResponse::setPrivateNetworkInformationText()
     * @uses ALCProductResponse::setPrivateNetworkOwner()
     * @uses ALCProductResponse::setPrivateNetworkType()
     * @uses ALCProductResponse::setBruttoDownLinkSpeed()
     * @uses ALCProductResponse::setBruttoUpLinkSpeed()
     * @uses ALCProductResponse::setNettoDownLinkSpeed()
     * @uses ALCProductResponse::setNettoUpLinkSpeed()
     * @param string[] $remarksProperties
     * @param string[] $allAvailableServiceClassText
     * @param \kapaks\StructType\Address $address
     * @param string $answerText
     * @param int $answerCode
     * @param int $bestBitrateDown
     * @param int $bestBitrateUp
     * @param string $bestServiceClassCode
     * @param string $bestServiceClassText
     * @param string $bkat
     * @param string $broadbandLineStatus
     * @param string $broadbandNumber
     * @param string $callDate
     * @param int $dropLength
     * @param string $dropLengthType
     * @param string $equipmentDeliveryDate
     * @param int $kapaksId
     * @param string $lineDeliveryDate
     * @param string $lineNumber
     * @param \kapaks\StructType\LinePart[] $linePart
     * @param string $part
     * @param string $reason
     * @param string $referenceId
     * @param int[] $remarksCode
     * @param string[] $remarksText
     * @param string $reqConnectionNumber
     * @param string $reqConnectionNumberType
     * @param string $requestedProduct
     * @param string $responseDate
     * @param int $resultCode
     * @param string $resultText
     * @param string[] $serviceType
     * @param int $statusCode
     * @param string $statusComment
     * @param string $statusText
     * @param string $telephoneLineStatus
     * @param string $telephoneNumber
     * @param string $telsisFSL
     * @param string $telsisGSL
     * @param string $telsisMotherSign
     * @param int $totalLength
     * @param int $prodInstBitrateDown
     * @param int $prodInstBitrateUp
     * @param string $productInstalled
     * @param string $subscriberName
     * @param \kapaks\StructType\Equipment[] $equipment
     * @param string[] $spareCapsPR
     * @param string $equipmentForTVDeliveryDate
     * @param int[] $allAvailableServiceClassCode
     * @param string $multicastSupport
     * @param string $measuredResultInfo
     * @param int $numberOfFreeLines
     * @param \kapaks\StructType\WimaxEquipment $wimaxEquipment
     * @param int $physicalLineId
     * @param string $privateNetworkInformationText
     * @param string $privateNetworkOwner
     * @param string $privateNetworkType
     * @param string $bruttoDownLinkSpeed
     * @param string $bruttoUpLinkSpeed
     * @param string $nettoDownLinkSpeed
     * @param string $nettoUpLinkSpeed
     */
    public function __construct(array $remarksProperties = array(), array $allAvailableServiceClassText = array(), \kapaks\StructType\Address $address = null, $answerText = null, $answerCode = null, $bestBitrateDown = null, $bestBitrateUp = null, $bestServiceClassCode = null, $bestServiceClassText = null, $bkat = null, $broadbandLineStatus = null, $broadbandNumber = null, $callDate = null, $dropLength = null, $dropLengthType = null, $equipmentDeliveryDate = null, $kapaksId = null, $lineDeliveryDate = null, $lineNumber = null, array $linePart = array(), $part = null, $reason = null, $referenceId = null, array $remarksCode = array(), array $remarksText = array(), $reqConnectionNumber = null, $reqConnectionNumberType = null, $requestedProduct = null, $responseDate = null, $resultCode = null, $resultText = null, array $serviceType = array(), $statusCode = null, $statusComment = null, $statusText = null, $telephoneLineStatus = null, $telephoneNumber = null, $telsisFSL = null, $telsisGSL = null, $telsisMotherSign = null, $totalLength = null, $prodInstBitrateDown = null, $prodInstBitrateUp = null, $productInstalled = null, $subscriberName = null, array $equipment = array(), array $spareCapsPR = array(), $equipmentForTVDeliveryDate = null, array $allAvailableServiceClassCode = array(), $multicastSupport = null, $measuredResultInfo = null, $numberOfFreeLines = null, \kapaks\StructType\WimaxEquipment $wimaxEquipment = null, $physicalLineId = null, $privateNetworkInformationText = null, $privateNetworkOwner = null, $privateNetworkType = null, $bruttoDownLinkSpeed = null, $bruttoUpLinkSpeed = null, $nettoDownLinkSpeed = null, $nettoUpLinkSpeed = null)
    {
        $this
            ->setRemarksProperties($remarksProperties)
            ->setAllAvailableServiceClassText($allAvailableServiceClassText)
            ->setAddress($address)
            ->setAnswerText($answerText)
            ->setAnswerCode($answerCode)
            ->setBestBitrateDown($bestBitrateDown)
            ->setBestBitrateUp($bestBitrateUp)
            ->setBestServiceClassCode($bestServiceClassCode)
            ->setBestServiceClassText($bestServiceClassText)
            ->setBkat($bkat)
            ->setBroadbandLineStatus($broadbandLineStatus)
            ->setBroadbandNumber($broadbandNumber)
            ->setCallDate($callDate)
            ->setDropLength($dropLength)
            ->setDropLengthType($dropLengthType)
            ->setEquipmentDeliveryDate($equipmentDeliveryDate)
            ->setKapaksId($kapaksId)
            ->setLineDeliveryDate($lineDeliveryDate)
            ->setLineNumber($lineNumber)
            ->setLinePart($linePart)
            ->setPart($part)
            ->setReason($reason)
            ->setReferenceId($referenceId)
            ->setRemarksCode($remarksCode)
            ->setRemarksText($remarksText)
            ->setReqConnectionNumber($reqConnectionNumber)
            ->setReqConnectionNumberType($reqConnectionNumberType)
            ->setRequestedProduct($requestedProduct)
            ->setResponseDate($responseDate)
            ->setResultCode($resultCode)
            ->setResultText($resultText)
            ->setServiceType($serviceType)
            ->setStatusCode($statusCode)
            ->setStatusComment($statusComment)
            ->setStatusText($statusText)
            ->setTelephoneLineStatus($telephoneLineStatus)
            ->setTelephoneNumber($telephoneNumber)
            ->setTelsisFSL($telsisFSL)
            ->setTelsisGSL($telsisGSL)
            ->setTelsisMotherSign($telsisMotherSign)
            ->setTotalLength($totalLength)
            ->setProdInstBitrateDown($prodInstBitrateDown)
            ->setProdInstBitrateUp($prodInstBitrateUp)
            ->setProductInstalled($productInstalled)
            ->setSubscriberName($subscriberName)
            ->setEquipment($equipment)
            ->setSpareCapsPR($spareCapsPR)
            ->setEquipmentForTVDeliveryDate($equipmentForTVDeliveryDate)
            ->setAllAvailableServiceClassCode($allAvailableServiceClassCode)
            ->setMulticastSupport($multicastSupport)
            ->setMeasuredResultInfo($measuredResultInfo)
            ->setNumberOfFreeLines($numberOfFreeLines)
            ->setWimaxEquipment($wimaxEquipment)
            ->setPhysicalLineId($physicalLineId)
            ->setPrivateNetworkInformationText($privateNetworkInformationText)
            ->setPrivateNetworkOwner($privateNetworkOwner)
            ->setPrivateNetworkType($privateNetworkType)
            ->setBruttoDownLinkSpeed($bruttoDownLinkSpeed)
            ->setBruttoUpLinkSpeed($bruttoUpLinkSpeed)
            ->setNettoDownLinkSpeed($nettoDownLinkSpeed)
            ->setNettoUpLinkSpeed($nettoUpLinkSpeed);
    }
    /**
     * Get remarksProperties value
     * @return string[]|null
     */
    public function getRemarksProperties()
    {
        return $this->remarksProperties;
    }
    /**
     * Set remarksProperties value
     * @throws \InvalidArgumentException
     * @param string[] $remarksProperties
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setRemarksProperties(array $remarksProperties = array())
    {
        foreach ($remarksProperties as $aLCProductResponseRemarksPropertiesItem) {
            // validation for constraint: itemType
            if (!is_string($aLCProductResponseRemarksPropertiesItem)) {
                throw new \InvalidArgumentException(sprintf('The remarksProperties property can only contain items of string, "%s" given', is_object($aLCProductResponseRemarksPropertiesItem) ? get_class($aLCProductResponseRemarksPropertiesItem) : gettype($aLCProductResponseRemarksPropertiesItem)), __LINE__);
            }
        }
        $this->remarksProperties = $remarksProperties;
        return $this;
    }
    /**
     * Add item to remarksProperties value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToRemarksProperties($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The remarksProperties property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->remarksProperties[] = $item;
        return $this;
    }
    /**
     * Get allAvailableServiceClassText value
     * @return string[]|null
     */
    public function getAllAvailableServiceClassText()
    {
        return $this->allAvailableServiceClassText;
    }
    /**
     * Set allAvailableServiceClassText value
     * @throws \InvalidArgumentException
     * @param string[] $allAvailableServiceClassText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setAllAvailableServiceClassText(array $allAvailableServiceClassText = array())
    {
        foreach ($allAvailableServiceClassText as $aLCProductResponseAllAvailableServiceClassTextItem) {
            // validation for constraint: itemType
            if (!is_string($aLCProductResponseAllAvailableServiceClassTextItem)) {
                throw new \InvalidArgumentException(sprintf('The allAvailableServiceClassText property can only contain items of string, "%s" given', is_object($aLCProductResponseAllAvailableServiceClassTextItem) ? get_class($aLCProductResponseAllAvailableServiceClassTextItem) : gettype($aLCProductResponseAllAvailableServiceClassTextItem)), __LINE__);
            }
        }
        $this->allAvailableServiceClassText = $allAvailableServiceClassText;
        return $this;
    }
    /**
     * Add item to allAvailableServiceClassText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToAllAvailableServiceClassText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The allAvailableServiceClassText property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->allAvailableServiceClassText[] = $item;
        return $this;
    }
    /**
     * Get address value
     * @return \kapaks\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \kapaks\StructType\Address $address
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setAddress(\kapaks\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get answerText value
     * @return string|null
     */
    public function getAnswerText()
    {
        return $this->answerText;
    }
    /**
     * Set answerText value
     * @param string $answerText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setAnswerText($answerText = null)
    {
        // validation for constraint: string
        if (!is_null($answerText) && !is_string($answerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerText)), __LINE__);
        }
        $this->answerText = $answerText;
        return $this;
    }
    /**
     * Get answerCode value
     * @return int|null
     */
    public function getAnswerCode()
    {
        return $this->answerCode;
    }
    /**
     * Set answerCode value
     * @param int $answerCode
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setAnswerCode($answerCode = null)
    {
        // validation for constraint: int
        if (!is_null($answerCode) && !is_numeric($answerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($answerCode)), __LINE__);
        }
        $this->answerCode = $answerCode;
        return $this;
    }
    /**
     * Get bestBitrateDown value
     * @return int|null
     */
    public function getBestBitrateDown()
    {
        return $this->bestBitrateDown;
    }
    /**
     * Set bestBitrateDown value
     * @param int $bestBitrateDown
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBestBitrateDown($bestBitrateDown = null)
    {
        // validation for constraint: int
        if (!is_null($bestBitrateDown) && !is_numeric($bestBitrateDown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bestBitrateDown)), __LINE__);
        }
        $this->bestBitrateDown = $bestBitrateDown;
        return $this;
    }
    /**
     * Get bestBitrateUp value
     * @return int|null
     */
    public function getBestBitrateUp()
    {
        return $this->bestBitrateUp;
    }
    /**
     * Set bestBitrateUp value
     * @param int $bestBitrateUp
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBestBitrateUp($bestBitrateUp = null)
    {
        // validation for constraint: int
        if (!is_null($bestBitrateUp) && !is_numeric($bestBitrateUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bestBitrateUp)), __LINE__);
        }
        $this->bestBitrateUp = $bestBitrateUp;
        return $this;
    }
    /**
     * Get bestServiceClassCode value
     * @return string|null
     */
    public function getBestServiceClassCode()
    {
        return $this->bestServiceClassCode;
    }
    /**
     * Set bestServiceClassCode value
     * @param string $bestServiceClassCode
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBestServiceClassCode($bestServiceClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($bestServiceClassCode) && !is_string($bestServiceClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bestServiceClassCode)), __LINE__);
        }
        $this->bestServiceClassCode = $bestServiceClassCode;
        return $this;
    }
    /**
     * Get bestServiceClassText value
     * @return string|null
     */
    public function getBestServiceClassText()
    {
        return $this->bestServiceClassText;
    }
    /**
     * Set bestServiceClassText value
     * @param string $bestServiceClassText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBestServiceClassText($bestServiceClassText = null)
    {
        // validation for constraint: string
        if (!is_null($bestServiceClassText) && !is_string($bestServiceClassText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bestServiceClassText)), __LINE__);
        }
        $this->bestServiceClassText = $bestServiceClassText;
        return $this;
    }
    /**
     * Get bkat value
     * @return string|null
     */
    public function getBkat()
    {
        return $this->bkat;
    }
    /**
     * Set bkat value
     * @param string $bkat
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBkat($bkat = null)
    {
        // validation for constraint: string
        if (!is_null($bkat) && !is_string($bkat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bkat)), __LINE__);
        }
        $this->bkat = $bkat;
        return $this;
    }
    /**
     * Get broadbandLineStatus value
     * @return string|null
     */
    public function getBroadbandLineStatus()
    {
        return $this->broadbandLineStatus;
    }
    /**
     * Set broadbandLineStatus value
     * @param string $broadbandLineStatus
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBroadbandLineStatus($broadbandLineStatus = null)
    {
        // validation for constraint: string
        if (!is_null($broadbandLineStatus) && !is_string($broadbandLineStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($broadbandLineStatus)), __LINE__);
        }
        $this->broadbandLineStatus = $broadbandLineStatus;
        return $this;
    }
    /**
     * Get broadbandNumber value
     * @return string|null
     */
    public function getBroadbandNumber()
    {
        return $this->broadbandNumber;
    }
    /**
     * Set broadbandNumber value
     * @param string $broadbandNumber
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBroadbandNumber($broadbandNumber = null)
    {
        // validation for constraint: string
        if (!is_null($broadbandNumber) && !is_string($broadbandNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($broadbandNumber)), __LINE__);
        }
        $this->broadbandNumber = $broadbandNumber;
        return $this;
    }
    /**
     * Get callDate value
     * @return string|null
     */
    public function getCallDate()
    {
        return $this->callDate;
    }
    /**
     * Set callDate value
     * @param string $callDate
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setCallDate($callDate = null)
    {
        // validation for constraint: string
        if (!is_null($callDate) && !is_string($callDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callDate)), __LINE__);
        }
        $this->callDate = $callDate;
        return $this;
    }
    /**
     * Get dropLength value
     * @return int|null
     */
    public function getDropLength()
    {
        return $this->dropLength;
    }
    /**
     * Set dropLength value
     * @param int $dropLength
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setDropLength($dropLength = null)
    {
        // validation for constraint: int
        if (!is_null($dropLength) && !is_numeric($dropLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dropLength)), __LINE__);
        }
        $this->dropLength = $dropLength;
        return $this;
    }
    /**
     * Get dropLengthType value
     * @return string|null
     */
    public function getDropLengthType()
    {
        return $this->dropLengthType;
    }
    /**
     * Set dropLengthType value
     * @param string $dropLengthType
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setDropLengthType($dropLengthType = null)
    {
        // validation for constraint: string
        if (!is_null($dropLengthType) && !is_string($dropLengthType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dropLengthType)), __LINE__);
        }
        $this->dropLengthType = $dropLengthType;
        return $this;
    }
    /**
     * Get equipmentDeliveryDate value
     * @return string|null
     */
    public function getEquipmentDeliveryDate()
    {
        return $this->equipmentDeliveryDate;
    }
    /**
     * Set equipmentDeliveryDate value
     * @param string $equipmentDeliveryDate
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setEquipmentDeliveryDate($equipmentDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentDeliveryDate) && !is_string($equipmentDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentDeliveryDate)), __LINE__);
        }
        $this->equipmentDeliveryDate = $equipmentDeliveryDate;
        return $this;
    }
    /**
     * Get kapaksId value
     * @return int|null
     */
    public function getKapaksId()
    {
        return $this->kapaksId;
    }
    /**
     * Set kapaksId value
     * @param int $kapaksId
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setKapaksId($kapaksId = null)
    {
        // validation for constraint: int
        if (!is_null($kapaksId) && !is_numeric($kapaksId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kapaksId)), __LINE__);
        }
        $this->kapaksId = $kapaksId;
        return $this;
    }
    /**
     * Get lineDeliveryDate value
     * @return string|null
     */
    public function getLineDeliveryDate()
    {
        return $this->lineDeliveryDate;
    }
    /**
     * Set lineDeliveryDate value
     * @param string $lineDeliveryDate
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setLineDeliveryDate($lineDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($lineDeliveryDate) && !is_string($lineDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineDeliveryDate)), __LINE__);
        }
        $this->lineDeliveryDate = $lineDeliveryDate;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return string|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param string $lineNumber
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineNumber) && !is_string($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get linePart value
     * @return \kapaks\StructType\LinePart[]|null
     */
    public function getLinePart()
    {
        return $this->linePart;
    }
    /**
     * Set linePart value
     * @throws \InvalidArgumentException
     * @param \kapaks\StructType\LinePart[] $linePart
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setLinePart(array $linePart = array())
    {
        foreach ($linePart as $aLCProductResponseLinePartItem) {
            // validation for constraint: itemType
            if (!$aLCProductResponseLinePartItem instanceof \kapaks\StructType\LinePart) {
                throw new \InvalidArgumentException(sprintf('The linePart property can only contain items of \kapaks\StructType\LinePart, "%s" given', is_object($aLCProductResponseLinePartItem) ? get_class($aLCProductResponseLinePartItem) : gettype($aLCProductResponseLinePartItem)), __LINE__);
            }
        }
        $this->linePart = $linePart;
        return $this;
    }
    /**
     * Add item to linePart value
     * @throws \InvalidArgumentException
     * @param \kapaks\StructType\LinePart $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToLinePart(\kapaks\StructType\LinePart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \kapaks\StructType\LinePart) {
            throw new \InvalidArgumentException(sprintf('The linePart property can only contain items of \kapaks\StructType\LinePart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->linePart[] = $item;
        return $this;
    }
    /**
     * Get part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param string $part
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setPart($part = null)
    {
        // validation for constraint: string
        if (!is_null($part) && !is_string($part)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($part)), __LINE__);
        }
        $this->part = $part;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get referenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }
    /**
     * Set referenceId value
     * @param string $referenceId
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceId)), __LINE__);
        }
        $this->referenceId = $referenceId;
        return $this;
    }
    /**
     * Get remarksCode value
     * @return int[]|null
     */
    public function getRemarksCode()
    {
        return $this->remarksCode;
    }
    /**
     * Set remarksCode value
     * @throws \InvalidArgumentException
     * @param int[] $remarksCode
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setRemarksCode(array $remarksCode = array())
    {
        foreach ($remarksCode as $aLCProductResponseRemarksCodeItem) {
            // validation for constraint: itemType
            if (!is_numeric($aLCProductResponseRemarksCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The remarksCode property can only contain items of int, "%s" given', is_object($aLCProductResponseRemarksCodeItem) ? get_class($aLCProductResponseRemarksCodeItem) : gettype($aLCProductResponseRemarksCodeItem)), __LINE__);
            }
        }
        $this->remarksCode = $remarksCode;
        return $this;
    }
    /**
     * Add item to remarksCode value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToRemarksCode($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The remarksCode property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->remarksCode[] = $item;
        return $this;
    }
    /**
     * Get remarksText value
     * @return string[]|null
     */
    public function getRemarksText()
    {
        return $this->remarksText;
    }
    /**
     * Set remarksText value
     * @throws \InvalidArgumentException
     * @param string[] $remarksText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setRemarksText(array $remarksText = array())
    {
        foreach ($remarksText as $aLCProductResponseRemarksTextItem) {
            // validation for constraint: itemType
            if (!is_string($aLCProductResponseRemarksTextItem)) {
                throw new \InvalidArgumentException(sprintf('The remarksText property can only contain items of string, "%s" given', is_object($aLCProductResponseRemarksTextItem) ? get_class($aLCProductResponseRemarksTextItem) : gettype($aLCProductResponseRemarksTextItem)), __LINE__);
            }
        }
        $this->remarksText = $remarksText;
        return $this;
    }
    /**
     * Add item to remarksText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToRemarksText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The remarksText property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->remarksText[] = $item;
        return $this;
    }
    /**
     * Get reqConnectionNumber value
     * @return string|null
     */
    public function getReqConnectionNumber()
    {
        return $this->reqConnectionNumber;
    }
    /**
     * Set reqConnectionNumber value
     * @param string $reqConnectionNumber
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setReqConnectionNumber($reqConnectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reqConnectionNumber) && !is_string($reqConnectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqConnectionNumber)), __LINE__);
        }
        $this->reqConnectionNumber = $reqConnectionNumber;
        return $this;
    }
    /**
     * Get reqConnectionNumberType value
     * @return string|null
     */
    public function getReqConnectionNumberType()
    {
        return $this->reqConnectionNumberType;
    }
    /**
     * Set reqConnectionNumberType value
     * @param string $reqConnectionNumberType
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setReqConnectionNumberType($reqConnectionNumberType = null)
    {
        // validation for constraint: string
        if (!is_null($reqConnectionNumberType) && !is_string($reqConnectionNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqConnectionNumberType)), __LINE__);
        }
        $this->reqConnectionNumberType = $reqConnectionNumberType;
        return $this;
    }
    /**
     * Get requestedProduct value
     * @return string|null
     */
    public function getRequestedProduct()
    {
        return $this->requestedProduct;
    }
    /**
     * Set requestedProduct value
     * @param string $requestedProduct
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setRequestedProduct($requestedProduct = null)
    {
        // validation for constraint: string
        if (!is_null($requestedProduct) && !is_string($requestedProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedProduct)), __LINE__);
        }
        $this->requestedProduct = $requestedProduct;
        return $this;
    }
    /**
     * Get responseDate value
     * @return string|null
     */
    public function getResponseDate()
    {
        return $this->responseDate;
    }
    /**
     * Set responseDate value
     * @param string $responseDate
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setResponseDate($responseDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDate) && !is_string($responseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseDate)), __LINE__);
        }
        $this->responseDate = $responseDate;
        return $this;
    }
    /**
     * Get resultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->resultCode;
    }
    /**
     * Set resultCode value
     * @param int $resultCode
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !is_numeric($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->resultCode = $resultCode;
        return $this;
    }
    /**
     * Get resultText value
     * @return string|null
     */
    public function getResultText()
    {
        return $this->resultText;
    }
    /**
     * Set resultText value
     * @param string $resultText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setResultText($resultText = null)
    {
        // validation for constraint: string
        if (!is_null($resultText) && !is_string($resultText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultText)), __LINE__);
        }
        $this->resultText = $resultText;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string[]|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @throws \InvalidArgumentException
     * @param string[] $serviceType
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setServiceType(array $serviceType = array())
    {
        foreach ($serviceType as $aLCProductResponseServiceTypeItem) {
            // validation for constraint: itemType
            if (!is_string($aLCProductResponseServiceTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The serviceType property can only contain items of string, "%s" given', is_object($aLCProductResponseServiceTypeItem) ? get_class($aLCProductResponseServiceTypeItem) : gettype($aLCProductResponseServiceTypeItem)), __LINE__);
            }
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Add item to serviceType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToServiceType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The serviceType property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceType[] = $item;
        return $this;
    }
    /**
     * Get statusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param int $statusCode
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !is_numeric($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get statusComment value
     * @return string|null
     */
    public function getStatusComment()
    {
        return $this->statusComment;
    }
    /**
     * Set statusComment value
     * @param string $statusComment
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setStatusComment($statusComment = null)
    {
        // validation for constraint: string
        if (!is_null($statusComment) && !is_string($statusComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusComment)), __LINE__);
        }
        $this->statusComment = $statusComment;
        return $this;
    }
    /**
     * Get statusText value
     * @return string|null
     */
    public function getStatusText()
    {
        return $this->statusText;
    }
    /**
     * Set statusText value
     * @param string $statusText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusText)), __LINE__);
        }
        $this->statusText = $statusText;
        return $this;
    }
    /**
     * Get telephoneLineStatus value
     * @return string|null
     */
    public function getTelephoneLineStatus()
    {
        return $this->telephoneLineStatus;
    }
    /**
     * Set telephoneLineStatus value
     * @param string $telephoneLineStatus
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setTelephoneLineStatus($telephoneLineStatus = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneLineStatus) && !is_string($telephoneLineStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneLineStatus)), __LINE__);
        }
        $this->telephoneLineStatus = $telephoneLineStatus;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get telsisFSL value
     * @return string|null
     */
    public function getTelsisFSL()
    {
        return $this->telsisFSL;
    }
    /**
     * Set telsisFSL value
     * @param string $telsisFSL
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setTelsisFSL($telsisFSL = null)
    {
        // validation for constraint: string
        if (!is_null($telsisFSL) && !is_string($telsisFSL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telsisFSL)), __LINE__);
        }
        $this->telsisFSL = $telsisFSL;
        return $this;
    }
    /**
     * Get telsisGSL value
     * @return string|null
     */
    public function getTelsisGSL()
    {
        return $this->telsisGSL;
    }
    /**
     * Set telsisGSL value
     * @param string $telsisGSL
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setTelsisGSL($telsisGSL = null)
    {
        // validation for constraint: string
        if (!is_null($telsisGSL) && !is_string($telsisGSL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telsisGSL)), __LINE__);
        }
        $this->telsisGSL = $telsisGSL;
        return $this;
    }
    /**
     * Get telsisMotherSign value
     * @return string|null
     */
    public function getTelsisMotherSign()
    {
        return $this->telsisMotherSign;
    }
    /**
     * Set telsisMotherSign value
     * @param string $telsisMotherSign
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setTelsisMotherSign($telsisMotherSign = null)
    {
        // validation for constraint: string
        if (!is_null($telsisMotherSign) && !is_string($telsisMotherSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telsisMotherSign)), __LINE__);
        }
        $this->telsisMotherSign = $telsisMotherSign;
        return $this;
    }
    /**
     * Get totalLength value
     * @return int|null
     */
    public function getTotalLength()
    {
        return $this->totalLength;
    }
    /**
     * Set totalLength value
     * @param int $totalLength
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setTotalLength($totalLength = null)
    {
        // validation for constraint: int
        if (!is_null($totalLength) && !is_numeric($totalLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalLength)), __LINE__);
        }
        $this->totalLength = $totalLength;
        return $this;
    }
    /**
     * Get prodInstBitrateDown value
     * @return int|null
     */
    public function getProdInstBitrateDown()
    {
        return $this->prodInstBitrateDown;
    }
    /**
     * Set prodInstBitrateDown value
     * @param int $prodInstBitrateDown
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setProdInstBitrateDown($prodInstBitrateDown = null)
    {
        // validation for constraint: int
        if (!is_null($prodInstBitrateDown) && !is_numeric($prodInstBitrateDown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prodInstBitrateDown)), __LINE__);
        }
        $this->prodInstBitrateDown = $prodInstBitrateDown;
        return $this;
    }
    /**
     * Get prodInstBitrateUp value
     * @return int|null
     */
    public function getProdInstBitrateUp()
    {
        return $this->prodInstBitrateUp;
    }
    /**
     * Set prodInstBitrateUp value
     * @param int $prodInstBitrateUp
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setProdInstBitrateUp($prodInstBitrateUp = null)
    {
        // validation for constraint: int
        if (!is_null($prodInstBitrateUp) && !is_numeric($prodInstBitrateUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prodInstBitrateUp)), __LINE__);
        }
        $this->prodInstBitrateUp = $prodInstBitrateUp;
        return $this;
    }
    /**
     * Get productInstalled value
     * @return string|null
     */
    public function getProductInstalled()
    {
        return $this->productInstalled;
    }
    /**
     * Set productInstalled value
     * @param string $productInstalled
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setProductInstalled($productInstalled = null)
    {
        // validation for constraint: string
        if (!is_null($productInstalled) && !is_string($productInstalled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productInstalled)), __LINE__);
        }
        $this->productInstalled = $productInstalled;
        return $this;
    }
    /**
     * Get subscriberName value
     * @return string|null
     */
    public function getSubscriberName()
    {
        return $this->subscriberName;
    }
    /**
     * Set subscriberName value
     * @param string $subscriberName
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setSubscriberName($subscriberName = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberName) && !is_string($subscriberName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberName)), __LINE__);
        }
        $this->subscriberName = $subscriberName;
        return $this;
    }
    /**
     * Get equipment value
     * @return \kapaks\StructType\Equipment[]|null
     */
    public function getEquipment()
    {
        return $this->equipment;
    }
    /**
     * Set equipment value
     * @throws \InvalidArgumentException
     * @param \kapaks\StructType\Equipment[] $equipment
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $aLCProductResponseEquipmentItem) {
            // validation for constraint: itemType
            if (!$aLCProductResponseEquipmentItem instanceof \kapaks\StructType\Equipment) {
                throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \kapaks\StructType\Equipment, "%s" given', is_object($aLCProductResponseEquipmentItem) ? get_class($aLCProductResponseEquipmentItem) : gettype($aLCProductResponseEquipmentItem)), __LINE__);
            }
        }
        $this->equipment = $equipment;
        return $this;
    }
    /**
     * Add item to equipment value
     * @throws \InvalidArgumentException
     * @param \kapaks\StructType\Equipment $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToEquipment(\kapaks\StructType\Equipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \kapaks\StructType\Equipment) {
            throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \kapaks\StructType\Equipment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->equipment[] = $item;
        return $this;
    }
    /**
     * Get spareCapsPR value
     * @return string[]|null
     */
    public function getSpareCapsPR()
    {
        return $this->spareCapsPR;
    }
    /**
     * Set spareCapsPR value
     * @throws \InvalidArgumentException
     * @param string[] $spareCapsPR
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setSpareCapsPR(array $spareCapsPR = array())
    {
        foreach ($spareCapsPR as $aLCProductResponseSpareCapsPRItem) {
            // validation for constraint: itemType
            if (!is_string($aLCProductResponseSpareCapsPRItem)) {
                throw new \InvalidArgumentException(sprintf('The spareCapsPR property can only contain items of string, "%s" given', is_object($aLCProductResponseSpareCapsPRItem) ? get_class($aLCProductResponseSpareCapsPRItem) : gettype($aLCProductResponseSpareCapsPRItem)), __LINE__);
            }
        }
        $this->spareCapsPR = $spareCapsPR;
        return $this;
    }
    /**
     * Add item to spareCapsPR value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToSpareCapsPR($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The spareCapsPR property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->spareCapsPR[] = $item;
        return $this;
    }
    /**
     * Get equipmentForTVDeliveryDate value
     * @return string|null
     */
    public function getEquipmentForTVDeliveryDate()
    {
        return $this->equipmentForTVDeliveryDate;
    }
    /**
     * Set equipmentForTVDeliveryDate value
     * @param string $equipmentForTVDeliveryDate
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setEquipmentForTVDeliveryDate($equipmentForTVDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentForTVDeliveryDate) && !is_string($equipmentForTVDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentForTVDeliveryDate)), __LINE__);
        }
        $this->equipmentForTVDeliveryDate = $equipmentForTVDeliveryDate;
        return $this;
    }
    /**
     * Get allAvailableServiceClassCode value
     * @return int[]|null
     */
    public function getAllAvailableServiceClassCode()
    {
        return $this->allAvailableServiceClassCode;
    }
    /**
     * Set allAvailableServiceClassCode value
     * @throws \InvalidArgumentException
     * @param int[] $allAvailableServiceClassCode
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setAllAvailableServiceClassCode(array $allAvailableServiceClassCode = array())
    {
        foreach ($allAvailableServiceClassCode as $aLCProductResponseAllAvailableServiceClassCodeItem) {
            // validation for constraint: itemType
            if (!is_numeric($aLCProductResponseAllAvailableServiceClassCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The allAvailableServiceClassCode property can only contain items of int, "%s" given', is_object($aLCProductResponseAllAvailableServiceClassCodeItem) ? get_class($aLCProductResponseAllAvailableServiceClassCodeItem) : gettype($aLCProductResponseAllAvailableServiceClassCodeItem)), __LINE__);
            }
        }
        $this->allAvailableServiceClassCode = $allAvailableServiceClassCode;
        return $this;
    }
    /**
     * Add item to allAvailableServiceClassCode value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function addToAllAvailableServiceClassCode($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The allAvailableServiceClassCode property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->allAvailableServiceClassCode[] = $item;
        return $this;
    }
    /**
     * Get multicastSupport value
     * @return string|null
     */
    public function getMulticastSupport()
    {
        return $this->multicastSupport;
    }
    /**
     * Set multicastSupport value
     * @param string $multicastSupport
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setMulticastSupport($multicastSupport = null)
    {
        // validation for constraint: string
        if (!is_null($multicastSupport) && !is_string($multicastSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicastSupport)), __LINE__);
        }
        $this->multicastSupport = $multicastSupport;
        return $this;
    }
    /**
     * Get measuredResultInfo value
     * @return string|null
     */
    public function getMeasuredResultInfo()
    {
        return $this->measuredResultInfo;
    }
    /**
     * Set measuredResultInfo value
     * @param string $measuredResultInfo
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setMeasuredResultInfo($measuredResultInfo = null)
    {
        // validation for constraint: string
        if (!is_null($measuredResultInfo) && !is_string($measuredResultInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measuredResultInfo)), __LINE__);
        }
        $this->measuredResultInfo = $measuredResultInfo;
        return $this;
    }
    /**
     * Get numberOfFreeLines value
     * @return int|null
     */
    public function getNumberOfFreeLines()
    {
        return $this->numberOfFreeLines;
    }
    /**
     * Set numberOfFreeLines value
     * @param int $numberOfFreeLines
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setNumberOfFreeLines($numberOfFreeLines = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfFreeLines) && !is_numeric($numberOfFreeLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfFreeLines)), __LINE__);
        }
        $this->numberOfFreeLines = $numberOfFreeLines;
        return $this;
    }
    /**
     * Get wimaxEquipment value
     * @return \kapaks\StructType\WimaxEquipment|null
     */
    public function getWimaxEquipment()
    {
        return $this->wimaxEquipment;
    }
    /**
     * Set wimaxEquipment value
     * @param \kapaks\StructType\WimaxEquipment $wimaxEquipment
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setWimaxEquipment(\kapaks\StructType\WimaxEquipment $wimaxEquipment = null)
    {
        $this->wimaxEquipment = $wimaxEquipment;
        return $this;
    }
    /**
     * Get physicalLineId value
     * @return int|null
     */
    public function getPhysicalLineId()
    {
        return $this->physicalLineId;
    }
    /**
     * Set physicalLineId value
     * @param int $physicalLineId
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setPhysicalLineId($physicalLineId = null)
    {
        // validation for constraint: int
        if (!is_null($physicalLineId) && !is_numeric($physicalLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($physicalLineId)), __LINE__);
        }
        $this->physicalLineId = $physicalLineId;
        return $this;
    }
    /**
     * Get privateNetworkInformationText value
     * @return string|null
     */
    public function getPrivateNetworkInformationText()
    {
        return $this->privateNetworkInformationText;
    }
    /**
     * Set privateNetworkInformationText value
     * @param string $privateNetworkInformationText
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setPrivateNetworkInformationText($privateNetworkInformationText = null)
    {
        // validation for constraint: string
        if (!is_null($privateNetworkInformationText) && !is_string($privateNetworkInformationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateNetworkInformationText)), __LINE__);
        }
        $this->privateNetworkInformationText = $privateNetworkInformationText;
        return $this;
    }
    /**
     * Get privateNetworkOwner value
     * @return string|null
     */
    public function getPrivateNetworkOwner()
    {
        return $this->privateNetworkOwner;
    }
    /**
     * Set privateNetworkOwner value
     * @param string $privateNetworkOwner
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setPrivateNetworkOwner($privateNetworkOwner = null)
    {
        // validation for constraint: string
        if (!is_null($privateNetworkOwner) && !is_string($privateNetworkOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateNetworkOwner)), __LINE__);
        }
        $this->privateNetworkOwner = $privateNetworkOwner;
        return $this;
    }
    /**
     * Get privateNetworkType value
     * @return string|null
     */
    public function getPrivateNetworkType()
    {
        return $this->privateNetworkType;
    }
    /**
     * Set privateNetworkType value
     * @param string $privateNetworkType
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setPrivateNetworkType($privateNetworkType = null)
    {
        // validation for constraint: string
        if (!is_null($privateNetworkType) && !is_string($privateNetworkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateNetworkType)), __LINE__);
        }
        $this->privateNetworkType = $privateNetworkType;
        return $this;
    }
    /**
     * Get bruttoDownLinkSpeed value
     * @return string|null
     */
    public function getBruttoDownLinkSpeed()
    {
        return $this->bruttoDownLinkSpeed;
    }
    /**
     * Set bruttoDownLinkSpeed value
     * @param string $bruttoDownLinkSpeed
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBruttoDownLinkSpeed($bruttoDownLinkSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($bruttoDownLinkSpeed) && !is_string($bruttoDownLinkSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bruttoDownLinkSpeed)), __LINE__);
        }
        $this->bruttoDownLinkSpeed = $bruttoDownLinkSpeed;
        return $this;
    }
    /**
     * Get bruttoUpLinkSpeed value
     * @return string|null
     */
    public function getBruttoUpLinkSpeed()
    {
        return $this->bruttoUpLinkSpeed;
    }
    /**
     * Set bruttoUpLinkSpeed value
     * @param string $bruttoUpLinkSpeed
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setBruttoUpLinkSpeed($bruttoUpLinkSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($bruttoUpLinkSpeed) && !is_string($bruttoUpLinkSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bruttoUpLinkSpeed)), __LINE__);
        }
        $this->bruttoUpLinkSpeed = $bruttoUpLinkSpeed;
        return $this;
    }
    /**
     * Get nettoDownLinkSpeed value
     * @return string|null
     */
    public function getNettoDownLinkSpeed()
    {
        return $this->nettoDownLinkSpeed;
    }
    /**
     * Set nettoDownLinkSpeed value
     * @param string $nettoDownLinkSpeed
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setNettoDownLinkSpeed($nettoDownLinkSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($nettoDownLinkSpeed) && !is_string($nettoDownLinkSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nettoDownLinkSpeed)), __LINE__);
        }
        $this->nettoDownLinkSpeed = $nettoDownLinkSpeed;
        return $this;
    }
    /**
     * Get nettoUpLinkSpeed value
     * @return string|null
     */
    public function getNettoUpLinkSpeed()
    {
        return $this->nettoUpLinkSpeed;
    }
    /**
     * Set nettoUpLinkSpeed value
     * @param string $nettoUpLinkSpeed
     * @return \kapaks\StructType\ALCProductResponse
     */
    public function setNettoUpLinkSpeed($nettoUpLinkSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($nettoUpLinkSpeed) && !is_string($nettoUpLinkSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nettoUpLinkSpeed)), __LINE__);
        }
        $this->nettoUpLinkSpeed = $nettoUpLinkSpeed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \kapaks\StructType\ALCProductResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
