<?php

namespace kapaks\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named validateProductSoap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \kapaks\StructType\ValidateProductSoap $parameters
     * @return \kapaks\StructType\ValidateProductSoapResponse|bool
     */
    public function validateProductSoap(\kapaks\StructType\ValidateProductSoap $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->validateProductSoap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named validateRelocationSoap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \kapaks\StructType\ValidateRelocationSoap $parameters
     * @return \kapaks\StructType\ValidateRelocationSoapResponse|bool
     */
    public function validateRelocationSoap(\kapaks\StructType\ValidateRelocationSoap $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->validateRelocationSoap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \kapaks\StructType\ValidateProductSoapResponse|\kapaks\StructType\ValidateRelocationSoapResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
