<?php

namespace kapaks\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deep ServiceType
 * @subpackage Services
 */
class Deep extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deepPing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \kapaks\StructType\DeepPing $parameters
     * @return \kapaks\StructType\DeepPingResponse|bool
     */
    public function deepPing(\kapaks\StructType\DeepPing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deepPing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \kapaks\StructType\DeepPingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
