<?php

namespace kapaks;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ALCProductRequest' => '\\kapaks\\StructType\\ALCProductRequest',
            'ProductRequest' => '\\kapaks\\StructType\\ProductRequest',
            'Address' => '\\kapaks\\StructType\\Address',
            'ALCProductResponse' => '\\kapaks\\StructType\\ALCProductResponse',
            'LinePart' => '\\kapaks\\StructType\\LinePart',
            'Equipment' => '\\kapaks\\StructType\\Equipment',
            'WimaxEquipment' => '\\kapaks\\StructType\\WimaxEquipment',
            'ALCRelocationRequest' => '\\kapaks\\StructType\\ALCRelocationRequest',
            'RelocationRequest' => '\\kapaks\\StructType\\RelocationRequest',
            'ALCRelocationResponse' => '\\kapaks\\StructType\\ALCRelocationResponse',
            'validateProductSoap' => '\\kapaks\\StructType\\ValidateProductSoap',
            'validateProductSoapResponse' => '\\kapaks\\StructType\\ValidateProductSoapResponse',
            'ping' => '\\kapaks\\StructType\\Ping',
            'pingResponse' => '\\kapaks\\StructType\\PingResponse',
            'validateRelocationSoap' => '\\kapaks\\StructType\\ValidateRelocationSoap',
            'validateRelocationSoapResponse' => '\\kapaks\\StructType\\ValidateRelocationSoapResponse',
            'deepPing' => '\\kapaks\\StructType\\DeepPing',
            'deepPingResponse' => '\\kapaks\\StructType\\DeepPingResponse',
            'MetroSOAPException' => '\\kapaks\\StructType\\MetroSOAPException',
            'FaultDetail' => '\\kapaks\\StructType\\FaultDetail',
        );
    }
}
