<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unstructuredAddress StructType
 * @subpackage Structs
 */
class UnstructuredAddress extends AbstractStructBase
{
    /**
     * The addressLine1
     * Meta informations extracted from the WSDL
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $addressLine1;
    /**
     * The addressLine2
     * Meta informations extracted from the WSDL
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $addressLine2;
    /**
     * The addressLine3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $addressLine3;
    /**
     * The addressLine4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $addressLine4;
    /**
     * Constructor method for unstructuredAddress
     * @uses UnstructuredAddress::setAddressLine1()
     * @uses UnstructuredAddress::setAddressLine2()
     * @uses UnstructuredAddress::setAddressLine3()
     * @uses UnstructuredAddress::setAddressLine4()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $addressLine4
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $addressLine4 = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setAddressLine4($addressLine4);
    }
    /**
     * Get addressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->addressLine1;
    }
    /**
     * Set addressLine1 value
     * @param string $addressLine1
     * @return \StructType\UnstructuredAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressLine1) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($addressLine1, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->addressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get addressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->addressLine2;
    }
    /**
     * Set addressLine2 value
     * @param string $addressLine2
     * @return \StructType\UnstructuredAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressLine2) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($addressLine2, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->addressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get addressLine3 value
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->addressLine3;
    }
    /**
     * Set addressLine3 value
     * @param string $addressLine3
     * @return \StructType\UnstructuredAddress
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressLine3) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($addressLine3, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine3)), __LINE__);
        }
        $this->addressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get addressLine4 value
     * @return string|null
     */
    public function getAddressLine4()
    {
        return $this->addressLine4;
    }
    /**
     * Set addressLine4 value
     * @param string $addressLine4
     * @return \StructType\UnstructuredAddress
     */
    public function setAddressLine4($addressLine4 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressLine4) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($addressLine4, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine4) && !is_string($addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine4)), __LINE__);
        }
        $this->addressLine4 = $addressLine4;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnstructuredAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
