<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for traceListType StructType
 * Meta informations extracted from the WSDL
 * - documentation: ~Internal~
 * @subpackage Structs
 */
class TraceListType extends AbstractStructBase
{
    /**
     * The trace
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TraceType[]
     */
    public $trace;
    /**
     * Constructor method for traceListType
     * @uses TraceListType::setTrace()
     * @param \StructType\TraceType[] $trace
     */
    public function __construct(array $trace = array())
    {
        $this
            ->setTrace($trace);
    }
    /**
     * Get trace value
     * @return \StructType\TraceType[]|null
     */
    public function getTrace()
    {
        return $this->trace;
    }
    /**
     * Set trace value
     * @throws \InvalidArgumentException
     * @param \StructType\TraceType[] $trace
     * @return \StructType\TraceListType
     */
    public function setTrace(array $trace = array())
    {
        foreach ($trace as $traceListTypeTraceItem) {
            // validation for constraint: itemType
            if (!$traceListTypeTraceItem instanceof \StructType\TraceType) {
                throw new \InvalidArgumentException(sprintf('The trace property can only contain items of \StructType\TraceType, "%s" given', is_object($traceListTypeTraceItem) ? get_class($traceListTypeTraceItem) : gettype($traceListTypeTraceItem)), __LINE__);
            }
        }
        $this->trace = $trace;
        return $this;
    }
    /**
     * Add item to trace value
     * @throws \InvalidArgumentException
     * @param \StructType\TraceType $item
     * @return \StructType\TraceListType
     */
    public function addToTrace(\StructType\TraceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TraceType) {
            throw new \InvalidArgumentException(sprintf('The trace property can only contain items of \StructType\TraceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->trace[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TraceListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
